/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *
 */

import QtQuick 2.12
import QtQuick.Controls 2.5
import org.ukui.panel.items 1.0

ScrollBar {
    id: control
    property bool visual: true
    padding: (hovered || pressed) ? 3 : 5
    hoverEnabled: true

    Behavior on padding {
        NumberAnimation {
            duration: 200
            easing.type: Easing.InOutQuad
        }
    }

    contentItem: StyleBackground {
        radius: width / 2
        useStyleTransparency: false
        paletteRole: PaletteRole.Button
        //alpha: control.pressed ? 0.28 : control.hovered ? 0.18 : 0.10
        opacity: ((control.policy === ScrollBar.AlwaysOn || control.size < 1.0 ) && control.visual) ? 1.0 : 0.0
    }
}
