/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef QDENGINE_MINIGAMES_ADV_FLYOBJECT_H
#define QDENGINE_MINIGAMES_ADV_FLYOBJECT_H

namespace QDEngine {

struct FlyObjectBase {
	FlyObjectBase(const mgVect2f& _c = mgVect2f(), const mgVect2f& _t = mgVect2f(), float _s = 1.f);
	bool quant(float dt);

	mgVect2f current;
	mgVect2f target;
	float speed;
};

struct FlyQDObject : public FlyObjectBase {
	FlyQDObject(float dp = 0.f) : depth(dp), data(-1) {}
	FlyQDObject(const FlyObjectBase& crd, float dp, int dat) : FlyObjectBase(crd), depth(dp), data(dat) {}

	bool operator== (int dat) const {
		return data == dat;
	}

	bool quant(float dt, QDObject& obj);

	float depth;
	int data;
};

typedef Std::vector<FlyQDObject> FlyQDObjects;

} // namespace QDEngine

#endif // QDENGINE_MINIGAMES_ADV_FLYOBJECT_H
