#!/usr/bin/env ruby

$KCODE = 'SJIS'

proxy = ARGV.shift || nil

require 'soap/driver'

# XML Schema Datatypes1999łwi͂ȂȂĂj
require 'soap/XMLSchemaDatatypes1999'

# Wiredump̏o͐
def getWireDumpLogFile
  logFilename = File.basename( $0 ) + '.log'
  f = File.open( logFilename, 'w' )
  f << "File: #{ logFilename } - Wiredumps for SOAP4R client / #{ $serverName } server.\n"
  f << "Date: #{ Time.now }\n\n"
end

# T[rX̓o^i{ȂWSDLׂƂj
Server = 'http://www.hippo2000.net/cgi-bin/soap5tq2.cgi'
NS = 'urn:Soap5tq2'

drv = SOAP::Driver.new( nil, 'hippo5tq', NS, Server, proxy )
drv.setWireDumpDev( getWireDumpLogFile )

drv.addMethod( 'Init', 'UsrName', 'Passwd' )
  # => [ sSession, sErr ]
drv.addMethod( 'End', 'sSsID' )
  # => void
drv.addMethod( 'GetQuizAll', 'sSsId' )
  # => [ sQuiz0, sOpt00, sOpt01, sOpt02, sOpt03, sOpt04,
  #      ...
  #      sQuiz9, sOpt90, sOpt91, sOpt92, sOpt93, sOpt94 ]
drv.addMethod( 'RepQuizAll', 'sSsID', 'iRes' )
  # => [ iResult, iPoint ]
drv.addMethod( 'GetQuiz', 'sSsID' )
  # => [ sQuiz, sOpt0, sOpt1, sOpt2, sOpt3, sOpt4 ]
drv.addMethod( 'ReqQuiz', 'sSsID', 'iRes' )
  # => [ iResult, iPoint ]


# NCYT[rXւ̃OC
sessionId, errInfo =  drv.Init( 'SOAP4R', '' )

totalPoint = 0

# fBBB
trap( "INT" ) do | sig |
  puts "f܂"
  drv.End( sessionId )
  exit( -1 )
end

# ŏɈꊇăNCY擾Ă܂
quizAll = drv.GetQuizAll( sessionId )

# ׍H\bhd
def quizAll.next
  quiz, opt1, opt2, opt3, opt4, opt5 = self.slice!( 0..5 )
  return quiz, opt1, opt2, opt3, opt4, opt5
end

def quizAll.eof?
  ( self.length < 6 )
end

# NCYJn

# NCY̎cĂԁBBB
while !quizAll.eof?
  quiz, *opt = quizAll.next

  # o
  puts '-' * 78
  puts quiz
  1.upto( opt.length ) do | i |
    puts "#{ i }: #{ opt[ i-1 ] }"
  end

  # 
  ans = gets.chomp.to_i

  # 񓚂ƍ
  result, point = drv.RepQuizAll( sessionId, ans - 1 )

  # 茋ʂ?
  unless result.zero?
    puts " _: #{ point }"
    totalPoint += point
  else
    puts "nY"
  end
end

puts "Total: #{ totalPoint }"

# OIt
drv.End( sessionId )
