#!/usr/bin/env ruby

require 'rubygems'
require 'bundler/setup'
require 'ruby_ami'
require 'benchmark/ips'

env_string = "agi_request%3A%20async%0Aagi_channel%3A%20SIP%2F1234-00000000%0Aagi_language%3A%20en%0Aagi_type%3A%20SIP%0Aagi_uniqueid%3A%201320835995.0%0Aagi_version%3A%201.8.4.1%0Aagi_callerid%3A%205678%0Aagi_calleridname%3A%20Jane%20Smith%0Aagi_callingpres%3A%200%0Aagi_callingani2%3A%200%0Aagi_callington%3A%200%0Aagi_callingtns%3A%200%0Aagi_dnid%3A%201000%0Aagi_rdnis%3A%20unknown%0Aagi_context%3A%20default%0Aagi_extension%3A%201000%0Aagi_priority%3A%201%0Aagi_enhanced%3A%200.0%0Aagi_accountcode%3A%20%0Aagi_threadid%3A%204366221312%0A%0A"

Benchmark.ips do |ips|
  ips.report("environment parsing") { RubyAMI::AsyncAGIEnvironmentParser.new(env_string).to_hash }
  ips.report("CGI unescaping") { CGI.unescape(env_string) }
end
