# Announce: Rakudo compiler, Release #139 (2020.09)

On behalf of the Rakudo development team, I’m very happy to announce the
September 2020 release of Rakudo #139. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.09:
  + Additions:
    + Introducing the `Allomorph` class
      [716cacdc][4872c3f0][39bc2bdf][1b16da19][3cd51ae4]
    + Add `cmp` candidates for `Code` [4a34b266]
    + Add CAVEATS.md file [df68eb29][7e11234e][a1c7497f]
  + Build System:
    + Fix relocatable build-time NQP-home [eab3e1cb][5a40482d][077f8f97]
    + Fix `RUN_RAKUDO` to use the dummy Rakudo home [a56ce834]
    + Make `Perl6::SysConfig` depend on NQPs `HLL::SysConfig` [64eb6fcb]
  + Changes:
    + Method names that differ only in capitalization are now suggested
      when the method is not found
      [b7ff282f][30c4b6e5][bb7c617a][b054f9f0][df5b3d53][3703469d][8c015584]
    + Make `IO::Notification::Change` a value type [17f352f5][ad927871]
  + Deprecations:
    + The `parse-names` subroutine is now explicitly deprecated in 6.d
      to be be removed in 6.e, use `uniparse` subroutine instead [eef7383e]
  + Fixes:
    + Give a hint about missing provides in a META6.json when module
      is not found in CURFS [b2d625b9]
    + Make `Blob.gist` work for all sizes of `Blob` [f98861ad]
    + Prevent parser bug for multiple `[` in reduce metaop [86bac5ad]
    + Make JVM honor `PERL6_HOME` env variable [038fbc44][c9901246]
    + The `set`/`unset` methods on `SetHash` and the `add`/`remove` methods
      on `BagHash` give proper error message when called on a type object [b0b4459c]
    + Fix behavior of `Supply.head($n)` [46a72998]
    + Improve wording on `X::MultipleTypeSmiley` error [a9371749]
    + Fix long standing race condition in precompilation causing
      spurious test failures [3780c1d4]
    + Fix `--rakudo-home` Configure.pl parameter
  + Internal:
    + Start to use `nqp::execname` on the JVM backend [3ba803d2]
    + Test the install instead of the build runners [f2bf446c]
    + Add missing files to the `make clean` target for the JVM backend [58e729f6]
    + Tweak release-related scripts [d6e27314][ccb41617][a0c12cdd]
    + Remove use of deprecated `undefine` [e59262f6]
  + Efficiency:
    + Allow for more paralellism when precompiling modules, making
      parallel compilation faster [961a6535][86425339][0500ed3a]
    + Streamline `X::Multi::Ambiguous` listing [999680e6][b8121cec]


The following people contributed to this release:

Nicholas Clark, Vadim Belman, Will "Coke" Coleda, Elizabeth Mattijsen,
Juan Julián Merelo Guervós, Patrick Böker, Alexander Kiryuhin, Stoned Elipot,
rir, Daniel Sockwell, Timo Paulssen, Jonathan Worthington, Daniel Lathrop,
Christian Bartolomäus, stoned, Stefan Seifert, Norbert Buchmueller,
Tom Browder, Ben Davies, Daniel Green, Moritz Lenz, Paul Cochrane, Antonio,
Clifton Wood, Jan-Olof Hendig, L'Alabameñu, Shlomi Fish, Tobias Boege

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#140), is tentatively scheduled for 2020-10-24.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
