;;; racket-keywords-and-builtins.el -*- lexical-binding: t; -*-

;; Copyright (c) 2013-2020 by Greg Hendershott.

;; Author: Greg Hendershott
;; URL: https://github.com/greghendershott/racket-mode

;; License:
;; This is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version. This is distributed in the hope that it will be
;; useful, but without any warranty; without even the implied warranty
;; of merchantability or fitness for a particular purpose. See the GNU
;; General Public License for more details. See
;; http://www.gnu.org/licenses/ for details.

(defconst racket-type-list
  ;; This list was generated using keywords.rkt -- don't edit
  ;; individual items here!
  '("All"
    "Any"
    "AnyValues"
    "Async-ChannelTop"
    "Async-Channelof"
    "Boolean"
    "Bot"
    "BoxTop"
    "Boxof"
    "Byte"
    "Byte-PRegexp"
    "Byte-Regexp"
    "Bytes"
    "Bytes-Converter"
    "ChannelTop"
    "Channelof"
    "Char"
    "Class"
    "ClassTop"
    "Compiled-Expression"
    "Compiled-Module-Expression"
    "Complex"
    "Continuation-Mark-KeyTop"
    "Continuation-Mark-Keyof"
    "Continuation-Mark-Set"
    "Custodian"
    "Custodian-Boxof"
    "Datum"
    "EOF"
    "Environment-Variables"
    "Ephemeronof"
    "Evtof"
    "Exact-Complex"
    "Exact-Imaginary"
    "Exact-Nonnegative-Integer"
    "Exact-Number"
    "Exact-Positive-Integer"
    "Exact-Rational"
    "ExtFlVector"
    "ExtFlonum"
    "ExtFlonum-Nan"
    "ExtFlonum-Negative-Zero"
    "ExtFlonum-Positive-Zero"
    "ExtFlonum-Zero"
    "FSemaphore"
    "False"
    "Fixnum"
    "FlVector"
    "Float"
    "Float-Complex"
    "Float-Nan"
    "Float-Negative-Zero"
    "Float-Positive-Zero"
    "Float-Zero"
    "Flonum"
    "Flonum-Nan"
    "Flonum-Negative-Zero"
    "Flonum-Positive-Zero"
    "Flonum-Zero"
    "Futureof"
    "FxVector"
    "Has-Struct-Property"
    "HashTable"
    "HashTableTop"
    "Identifier"
    "Imaginary"
    "Immutable-HashTable"
    "Immutable-Vector"
    "Immutable-Vectorof"
    "Impersonator-Property"
    "Index"
    "Inexact-Complex"
    "Inexact-Imaginary"
    "Inexact-Real"
    "Inexact-Real-Nan"
    "Inexact-Real-Negative-Zero"
    "Inexact-Real-Positive-Zero"
    "Inexact-Real-Zero"
    "Input-Port"
    "Inspector"
    "Instance"
    "Integer"
    "Internal-Definition-Context"
    "Intersection"
    "Keyword"
    "List"
    "List*"
    "Listof"
    "Log-Level"
    "Log-Receiver"
    "Logger"
    "MListof"
    "MPairTop"
    "MPairof"
    "Module-Path"
    "Module-Path-Index"
    "Mutable-HashTable"
    "Mutable-HashTableTop"
    "Mutable-Vector"
    "Mutable-VectorTop"
    "Mutable-Vectorof"
    "Namespace"
    "Namespace-Anchor"
    "Natural"
    "Negative-Exact-Rational"
    "Negative-ExtFlonum"
    "Negative-Fixnum"
    "Negative-Float"
    "Negative-Flonum"
    "Negative-Inexact-Real"
    "Negative-Integer"
    "Negative-Real"
    "Negative-Single-Flonum"
    "Nonnegative-Exact-Rational"
    "Nonnegative-ExtFlonum"
    "Nonnegative-Fixnum"
    "Nonnegative-Float"
    "Nonnegative-Flonum"
    "Nonnegative-Inexact-Real"
    "Nonnegative-Integer"
    "Nonnegative-Real"
    "Nonnegative-Single-Flonum"
    "Nonpositive-Exact-Rational"
    "Nonpositive-ExtFlonum"
    "Nonpositive-Fixnum"
    "Nonpositive-Float"
    "Nonpositive-Flonum"
    "Nonpositive-Inexact-Real"
    "Nonpositive-Integer"
    "Nonpositive-Real"
    "Nonpositive-Single-Flonum"
    "Nothing"
    "Null"
    "Number"
    "Object"
    "One"
    "Opaque"
    "Option"
    "Output-Port"
    "PRegexp"
    "Pair"
    "Pairof"
    "Parameter"
    "Parameterization"
    "Parameterof"
    "Path"
    "Path-For-Some-System"
    "Path-String"
    "Place"
    "Place-Channel"
    "Port"
    "Positive-Byte"
    "Positive-Exact-Rational"
    "Positive-ExtFlonum"
    "Positive-Fixnum"
    "Positive-Float"
    "Positive-Flonum"
    "Positive-Index"
    "Positive-Inexact-Real"
    "Positive-Integer"
    "Positive-Real"
    "Positive-Single-Flonum"
    "Prefab"
    "PrefabTop"
    "Pretty-Print-Style-Table"
    "Procedure"
    "Promise"
    "Prompt-TagTop"
    "Prompt-Tagof"
    "Pseudo-Random-Generator"
    "Read-Table"
    "Real"
    "Real-Zero"
    "Rec"
    "Refine"
    "Refinement"
    "Regexp"
    "Resolved-Module-Path"
    "Row"
    "Security-Guard"
    "Self"
    "Semaphore"
    "SequenceTop"
    "Sequenceof"
    "Setof"
    "Sexp"
    "Sexpof"
    "Single-Flonum"
    "Single-Flonum-Complex"
    "Single-Flonum-Nan"
    "Single-Flonum-Negative-Zero"
    "Single-Flonum-Positive-Zero"
    "Single-Flonum-Zero"
    "Some"
    "Special-Comment"
    "String"
    "Struct"
    "Struct-Property"
    "Struct-Type"
    "Struct-Type-Property"
    "Struct-TypeTop"
    "Subprocess"
    "Symbol"
    "Syntax"
    "Syntax-E"
    "Syntaxof"
    "TCP-Listener"
    "Thread"
    "Thread-CellTop"
    "Thread-Cellof"
    "Thread-Group"
    "Top"
    "True"
    "Tuple"
    "U"
    "UDP-Socket"
    "Un"
    "Undefined"
    "Union"
    "Unit"
    "UnitTop"
    "Unquoted-Printing-String"
    "Values"
    "Variable-Reference"
    "Vector"
    "VectorTop"
    "Vectorof"
    "Void"
    "Weak-BoxTop"
    "Weak-Boxof"
    "Weak-HashTable"
    "Weak-HashTableTop"
    "Will-Executor"
    "Zero")
  "Typed Racket builtin types")

(defconst racket-keywords
  ;; This list was generated using keywords.rkt -- don't edit
  ;; individual items here!
  '("#%app"
    "#%datum"
    "#%declare"
    "#%expression"
    "#%module-begin"
    "#%plain-app"
    "#%plain-lambda"
    "#%plain-module-begin"
    "#%printing-module-begin"
    "#%provide"
    "#%require"
    "#%stratified-body"
    "#%top"
    "#%top-interaction"
    "#%variable-reference"
    "..."
    ":do-in"
    "=>"
    "_"
    "all-defined-out"
    "all-from-out"
    "and"
    "apply"
    "arity-at-least"
    "begin"
    "begin-for-syntax"
    "begin0"
    "call-with-input-file"
    "call-with-input-file*"
    "call-with-output-file"
    "call-with-output-file*"
    "case"
    "case-lambda"
    "combine-in"
    "combine-out"
    "cond"
    "date"
    "date*"
    "define"
    "define-for-syntax"
    "define-logger"
    "define-namespace-anchor"
    "define-sequence-syntax"
    "define-struct"
    "define-struct/derived"
    "define-syntax"
    "define-syntax-rule"
    "define-syntaxes"
    "define-values"
    "define-values-for-syntax"
    "do"
    "else"
    "except-in"
    "except-out"
    "exn"
    "exn:break"
    "exn:break:hang-up"
    "exn:break:terminate"
    "exn:fail"
    "exn:fail:contract"
    "exn:fail:contract:arity"
    "exn:fail:contract:continuation"
    "exn:fail:contract:divide-by-zero"
    "exn:fail:contract:non-fixnum-result"
    "exn:fail:contract:variable"
    "exn:fail:filesystem"
    "exn:fail:filesystem:errno"
    "exn:fail:filesystem:exists"
    "exn:fail:filesystem:missing-module"
    "exn:fail:filesystem:version"
    "exn:fail:network"
    "exn:fail:network:errno"
    "exn:fail:out-of-memory"
    "exn:fail:read"
    "exn:fail:read:eof"
    "exn:fail:read:non-char"
    "exn:fail:syntax"
    "exn:fail:syntax:missing-module"
    "exn:fail:syntax:unbound"
    "exn:fail:unsupported"
    "exn:fail:user"
    "file"
    "for"
    "for*"
    "for*/and"
    "for*/first"
    "for*/fold"
    "for*/fold/derived"
    "for*/foldr"
    "for*/foldr/derived"
    "for*/hash"
    "for*/hasheq"
    "for*/hasheqv"
    "for*/last"
    "for*/list"
    "for*/lists"
    "for*/or"
    "for*/product"
    "for*/sum"
    "for*/vector"
    "for-label"
    "for-meta"
    "for-syntax"
    "for-template"
    "for/and"
    "for/first"
    "for/fold"
    "for/fold/derived"
    "for/foldr"
    "for/foldr/derived"
    "for/hash"
    "for/hasheq"
    "for/hasheqv"
    "for/last"
    "for/list"
    "for/lists"
    "for/or"
    "for/product"
    "for/sum"
    "for/vector"
    "gen:custom-write"
    "gen:equal+hash"
    "if"
    "in-bytes"
    "in-bytes-lines"
    "in-directory"
    "in-ephemeron-hash"
    "in-ephemeron-hash-keys"
    "in-ephemeron-hash-pairs"
    "in-ephemeron-hash-values"
    "in-hash"
    "in-hash-keys"
    "in-hash-pairs"
    "in-hash-values"
    "in-immutable-hash"
    "in-immutable-hash-keys"
    "in-immutable-hash-pairs"
    "in-immutable-hash-values"
    "in-inclusive-range"
    "in-indexed"
    "in-input-port-bytes"
    "in-input-port-chars"
    "in-lines"
    "in-list"
    "in-mlist"
    "in-mutable-hash"
    "in-mutable-hash-keys"
    "in-mutable-hash-pairs"
    "in-mutable-hash-values"
    "in-naturals"
    "in-port"
    "in-producer"
    "in-range"
    "in-string"
    "in-value"
    "in-vector"
    "in-weak-hash"
    "in-weak-hash-keys"
    "in-weak-hash-pairs"
    "in-weak-hash-values"
    "lambda"
    "let"
    "let*"
    "let*-values"
    "let-syntax"
    "let-syntaxes"
    "let-values"
    "let/cc"
    "let/ec"
    "letrec"
    "letrec-syntax"
    "letrec-syntaxes"
    "letrec-syntaxes+values"
    "letrec-values"
    "lib"
    "local-require"
    "log-debug"
    "log-error"
    "log-fatal"
    "log-info"
    "log-warning"
    "module"
    "module*"
    "module+"
    "only-in"
    "only-meta-in"
    "open-input-file"
    "open-input-output-file"
    "open-output-file"
    "or"
    "parameterize"
    "parameterize*"
    "parameterize-break"
    "planet"
    "prefix-in"
    "prefix-out"
    "protect-out"
    "provide"
    "quasiquote"
    "quasisyntax"
    "quasisyntax/loc"
    "quote"
    "quote-syntax"
    "quote-syntax/prune"
    "regexp-match*"
    "regexp-match-peek-positions*"
    "regexp-match-positions*"
    "relative-in"
    "rename-in"
    "rename-out"
    "require"
    "set!"
    "set!-values"
    "sort"
    "srcloc"
    "struct"
    "struct-copy"
    "struct-field-index"
    "struct-out"
    "struct/derived"
    "submod"
    "syntax"
    "syntax-binding-set-extend"
    "syntax-case"
    "syntax-case*"
    "syntax-deserialize"
    "syntax-id-rules"
    "syntax-rules"
    "syntax-serialize"
    "syntax/loc"
    "time"
    "unless"
    "unquote"
    "unquote-splicing"
    "unsyntax"
    "unsyntax-splicing"
    "when"
    "with-continuation-mark"
    "with-handlers"
    "with-handlers*"
    "with-input-from-file"
    "with-output-to-file"
    "with-syntax"
    "~?"
    "~@"
    "λ")
  "Racket \"keywords\": syntax from racket/base")

(defconst racket-builtins-1-of-2
  ;; This list was generated using keywords.rkt -- don't edit
  ;; individual items here!
  '("!"
    "*"
    "*list/c"
    "+"
    "-"
    "->"
    "->*"
    "->*m"
    "->d"
    "->dm"
    "->i"
    "->m"
    "/"
    ":"
    ":print-type"
    ":query-type/args"
    ":query-type/result"
    ":type"
    "<"
    "</c"
    "<="
    "<=/c"
    "="
    "=/c"
    "=="
    ">"
    ">/c"
    ">="
    ">=/c"
    "abort-current-continuation"
    "abs"
    "absent"
    "absolute-path?"
    "abstract"
    "acos"
    "add-between"
    "add1"
    "alarm-evt"
    "always-evt"
    "and/c"
    "andmap"
    "angle"
    "ann"
    "any"
    "any/c"
    "append"
    "append*"
    "append-map"
    "argmax"
    "argmin"
    "arithmetic-shift"
    "arity-at-least-value"
    "arity-at-least?"
    "arity-checking-wrapper"
    "arity-includes?"
    "arity=?"
    "arrow-contract-info"
    "arrow-contract-info-accepts-arglist"
    "arrow-contract-info-chaperone-procedure"
    "arrow-contract-info-check-first-order"
    "arrow-contract-info?"
    "asin"
    "assert"
    "assert-typecheck-fail"
    "assert-unreachable"
    "assf"
    "assoc"
    "assq"
    "assv"
    "atan"
    "augment"
    "augment*"
    "augment-final"
    "augment-final*"
    "augride"
    "augride*"
    "bad-number-of-results"
    "banner"
    "base->-doms/c"
    "base->-rngs/c"
    "base->?"
    "between/c"
    "bitwise-and"
    "bitwise-bit-field"
    "bitwise-bit-set?"
    "bitwise-ior"
    "bitwise-not"
    "bitwise-xor"
    "blame-add-car-context"
    "blame-add-cdr-context"
    "blame-add-context"
    "blame-add-missing-party"
    "blame-add-nth-arg-context"
    "blame-add-range-context"
    "blame-add-unknown-context"
    "blame-context"
    "blame-contract"
    "blame-fmt->-string"
    "blame-missing-party?"
    "blame-negative"
    "blame-original?"
    "blame-positive"
    "blame-replace-negative"
    "blame-replaced-negative?"
    "blame-source"
    "blame-swap"
    "blame-swapped?"
    "blame-update"
    "blame-value"
    "blame?"
    "boolean=?"
    "boolean?"
    "bound-identifier=?"
    "box"
    "box-cas!"
    "box-immutable"
    "box-immutable/c"
    "box/c"
    "box?"
    "break-enabled"
    "break-parameterization?"
    "break-thread"
    "build-chaperone-contract-property"
    "build-compound-type-name"
    "build-contract-property"
    "build-flat-contract-property"
    "build-list"
    "build-path"
    "build-path/convention-type"
    "build-string"
    "build-vector"
    "byte-pregexp"
    "byte-pregexp?"
    "byte-ready?"
    "byte-regexp"
    "byte-regexp?"
    "byte?"
    "bytes"
    "bytes->immutable-bytes"
    "bytes->list"
    "bytes->path"
    "bytes->path-element"
    "bytes->string/latin-1"
    "bytes->string/locale"
    "bytes->string/utf-8"
    "bytes-append"
    "bytes-append*"
    "bytes-close-converter"
    "bytes-convert"
    "bytes-convert-end"
    "bytes-converter?"
    "bytes-copy"
    "bytes-copy!"
    "bytes-environment-variable-name?"
    "bytes-fill!"
    "bytes-join"
    "bytes-length"
    "bytes-no-nuls?"
    "bytes-open-converter"
    "bytes-ref"
    "bytes-set!"
    "bytes-utf-8-index"
    "bytes-utf-8-length"
    "bytes-utf-8-ref"
    "bytes<?"
    "bytes=?"
    "bytes>?"
    "bytes?"
    "caaaar"
    "caaadr"
    "caaar"
    "caadar"
    "caaddr"
    "caadr"
    "caar"
    "cadaar"
    "cadadr"
    "cadar"
    "caddar"
    "cadddr"
    "caddr"
    "cadr"
    "call-in-continuation"
    "call-in-nested-thread"
    "call-with-atomic-output-file"
    "call-with-break-parameterization"
    "call-with-composable-continuation"
    "call-with-continuation-barrier"
    "call-with-continuation-prompt"
    "call-with-current-continuation"
    "call-with-default-reading-parameterization"
    "call-with-escape-continuation"
    "call-with-exception-handler"
    "call-with-file-lock/timeout"
    "call-with-immediate-continuation-mark"
    "call-with-input-bytes"
    "call-with-input-string"
    "call-with-output-bytes"
    "call-with-output-string"
    "call-with-parameterization"
    "call-with-semaphore"
    "call-with-semaphore/enable-break"
    "call-with-values"
    "call/cc"
    "call/ec"
    "car"
    "cartesian-product"
    "case->"
    "case->m"
    "case-lambda:"
    "case→"
    "cast"
    "cdaaar"
    "cdaadr"
    "cdaar"
    "cdadar"
    "cdaddr"
    "cdadr"
    "cdar"
    "cddaar"
    "cddadr"
    "cddar"
    "cdddar"
    "cddddr"
    "cdddr"
    "cddr"
    "cdr"
    "ceiling"
    "channel-get"
    "channel-put"
    "channel-put-evt"
    "channel-put-evt?"
    "channel-try-get"
    "channel/c"
    "channel?"
    "chaperone-box"
    "chaperone-channel"
    "chaperone-continuation-mark-key"
    "chaperone-contract-property?"
    "chaperone-contract?"
    "chaperone-evt"
    "chaperone-hash"
    "chaperone-hash-set"
    "chaperone-of?"
    "chaperone-procedure"
    "chaperone-procedure*"
    "chaperone-prompt-tag"
    "chaperone-struct"
    "chaperone-struct-type"
    "chaperone-vector"
    "chaperone-vector*"
    "chaperone?"
    "char->integer"
    "char-alphabetic?"
    "char-blank?"
    "char-ci<=?"
    "char-ci<?"
    "char-ci=?"
    "char-ci>=?"
    "char-ci>?"
    "char-downcase"
    "char-foldcase"
    "char-general-category"
    "char-graphic?"
    "char-in"
    "char-in/c"
    "char-iso-control?"
    "char-lower-case?"
    "char-numeric?"
    "char-punctuation?"
    "char-ready?"
    "char-symbolic?"
    "char-title-case?"
    "char-titlecase"
    "char-upcase"
    "char-upper-case?"
    "char-utf-8-length"
    "char-whitespace?"
    "char<=?"
    "char<?"
    "char=?"
    "char>=?"
    "char>?"
    "char?"
    "check-duplicate-identifier"
    "check-duplicates"
    "check-tail-contract"
    "checked-procedure-check-and-extract"
    "choice-evt"
    "class"
    "class*"
    "class->interface"
    "class-field-accessor"
    "class-field-mutator"
    "class-info"
    "class-seal"
    "class-unseal"
    "class/c"
    "class/derived"
    "class?"
    "cleanse-path"
    "close-input-port"
    "close-output-port"
    "coerce-chaperone-contract"
    "coerce-chaperone-contracts"
    "coerce-contract"
    "coerce-contract/f"
    "coerce-contracts"
    "coerce-flat-contract"
    "coerce-flat-contracts"
    "collect-garbage"
    "collection-file-path"
    "collection-path"
    "combinations"
    "combine-output"
    "command-line"
    "compile"
    "compile-allow-set!-undefined"
    "compile-context-preservation-enabled"
    "compile-enforce-module-constants"
    "compile-syntax"
    "compile-target-machine?"
    "compiled-expression-recompile"
    "compiled-expression?"
    "compiled-module-expression?"
    "complete-path?"
    "complex?"
    "compose"
    "compose1"
    "compound-unit"
    "compound-unit/infer"
    "conjoin"
    "conjugate"
    "cons"
    "cons/c"
    "cons/dc"
    "cons?"
    "const"
    "continuation-mark-key/c"
    "continuation-mark-key?"
    "continuation-mark-set->context"
    "continuation-mark-set->iterator"
    "continuation-mark-set->list"
    "continuation-mark-set->list*"
    "continuation-mark-set-first"
    "continuation-mark-set?"
    "continuation-marks"
    "continuation-prompt-available?"
    "continuation-prompt-tag?"
    "continuation?"
    "contract"
    "contract-continuation-mark-key"
    "contract-custom-write-property-proc"
    "contract-equivalent?"
    "contract-exercise"
    "contract-first-order"
    "contract-first-order-passes?"
    "contract-late-neg-projection"
    "contract-name"
    "contract-out"
    "contract-pos/neg-doubling"
    "contract-proc"
    "contract-projection"
    "contract-property?"
    "contract-random-generate"
    "contract-random-generate-env?"
    "contract-random-generate-fail"
    "contract-random-generate-fail?"
    "contract-random-generate-get-current-environment"
    "contract-random-generate-stash"
    "contract-random-generate/choose"
    "contract-stronger?"
    "contract-struct"
    "contract-struct-exercise"
    "contract-struct-generate"
    "contract-struct-late-neg-projection"
    "contract-struct-list-contract?"
    "contract-val-first-projection"
    "contract?"
    "contracted"
    "convert-stream"
    "copy-directory/files"
    "copy-file"
    "copy-port"
    "cos"
    "cosh"
    "count"
    "current-blame-format"
    "current-break-parameterization"
    "current-code-inspector"
    "current-command-line-arguments"
    "current-compile"
    "current-compile-target-machine"
    "current-compiled-file-roots"
    "current-continuation-marks"
    "current-contract-region"
    "current-custodian"
    "current-directory"
    "current-directory-for-user"
    "current-drive"
    "current-environment-variables"
    "current-error-port"
    "current-eval"
    "current-evt-pseudo-random-generator"
    "current-force-delete-permissions"
    "current-future"
    "current-gc-milliseconds"
    "current-get-interaction-input-port"
    "current-inexact-milliseconds"
    "current-inexact-monotonic-milliseconds"
    "current-input-port"
    "current-inspector"
    "current-library-collection-links"
    "current-library-collection-paths"
    "current-load"
    "current-load-extension"
    "current-load-relative-directory"
    "current-load/use-compiled"
    "current-locale"
    "current-logger"
    "current-memory-use"
    "current-milliseconds"
    "current-module-declare-name"
    "current-module-declare-source"
    "current-module-name-resolver"
    "current-module-path-for-load"
    "current-namespace"
    "current-output-port"
    "current-parameterization"
    "current-plumber"
    "current-preserved-thread-cell-values"
    "current-print"
    "current-process-milliseconds"
    "current-prompt-read"
    "current-pseudo-random-generator"
    "current-read-interaction"
    "current-reader-guard"
    "current-readtable"
    "current-recorded-disappeared-uses"
    "current-seconds"
    "current-security-guard"
    "current-subprocess-custodian-mode"
    "current-syntax-context"
    "current-thread"
    "current-thread-group"
    "current-thread-initial-stack-size"
    "current-write-relative-directory"
    "curry"
    "curryr"
    "custodian-box-value"
    "custodian-box?"
    "custodian-limit-memory"
    "custodian-managed-list"
    "custodian-memory-accounting-available?"
    "custodian-require-memory"
    "custodian-shut-down?"
    "custodian-shutdown-all"
    "custodian?"
    "custom-print-quotable-accessor"
    "custom-print-quotable?"
    "custom-write-accessor"
    "custom-write-property-proc"
    "custom-write?"
    "date*-nanosecond"
    "date*-time-zone-name"
    "date*?"
    "date-day"
    "date-dst?"
    "date-hour"
    "date-minute"
    "date-month"
    "date-second"
    "date-time-zone-offset"
    "date-week-day"
    "date-year"
    "date-year-day"
    "date?"
    "datum->syntax"
    "datum-intern-literal"
    "declare-refinement"
    "default-continuation-prompt-tag"
    "define-compound-unit"
    "define-compound-unit/infer"
    "define-contract-struct"
    "define-custom-hash-types"
    "define-custom-set-types"
    "define-local-member-name"
    "define-match-expander"
    "define-member-name"
    "define-module-boundary-contract"
    "define-new-subtype"
    "define-opt/c"
    "define-predicate"
    "define-serializable-class"
    "define-serializable-class*"
    "define-signature"
    "define-signature-form"
    "define-simple-macro"
    "define-struct/contract"
    "define-struct/exec"
    "define-struct/exec:"
    "define-struct:"
    "define-type"
    "define-type-alias"
    "define-typed-struct"
    "define-typed-struct/exec"
    "define-unit"
    "define-unit-binding"
    "define-unit-from-context"
    "define-unit/contract"
    "define-unit/new-import-export"
    "define-unit/s"
    "define-values-for-export"
    "define-values/invoke-unit"
    "define-values/invoke-unit/infer"
    "define/augment"
    "define/augment-final"
    "define/augride"
    "define/contract"
    "define/final-prop"
    "define/match"
    "define/overment"
    "define/override"
    "define/override-final"
    "define/private"
    "define/public"
    "define/public-final"
    "define/pubment"
    "define/subexpression-pos-prop"
    "define/subexpression-pos-prop/name"
    "define/with-syntax"
    "define:"
    "defined?"
    "degrees->radians"
    "delay"
    "delay/idle"
    "delay/name"
    "delay/strict"
    "delay/sync"
    "delay/thread"
    "delete-directory"
    "delete-directory/files"
    "delete-file"
    "denominator"
    "dict->list"
    "dict-can-functional-set?"
    "dict-can-remove-keys?"
    "dict-clear"
    "dict-clear!"
    "dict-copy"
    "dict-count"
    "dict-empty?"
    "dict-for-each"
    "dict-has-key?"
    "dict-implements/c"
    "dict-implements?"
    "dict-iter-contract"
    "dict-iterate-first"
    "dict-iterate-key"
    "dict-iterate-next"
    "dict-iterate-value"
    "dict-key-contract"
    "dict-keys"
    "dict-map"
    "dict-mutable?"
    "dict-ref"
    "dict-ref!"
    "dict-remove"
    "dict-remove!"
    "dict-set"
    "dict-set!"
    "dict-set*"
    "dict-set*!"
    "dict-update"
    "dict-update!"
    "dict-value-contract"
    "dict-values"
    "dict?"
    "directory-exists?"
    "directory-list"
    "disjoin"
    "display"
    "display-lines"
    "display-lines-to-file"
    "display-to-file"
    "displayln"
    "do-standard-inits"
    "do:"
    "double-flonum?"
    "drop"
    "drop-common-prefix"
    "drop-right"
    "dropf"
    "dropf-right"
    "dump-memory-stats"
    "dup-input-port"
    "dup-output-port"
    "dynamic->*"
    "dynamic-get-field"
    "dynamic-object/c"
    "dynamic-place"
    "dynamic-place*"
    "dynamic-require"
    "dynamic-require-for-syntax"
    "dynamic-send"
    "dynamic-set-field!"
    "dynamic-wind"
    "eighth"
    "empty"
    "empty-sequence"
    "empty-stream"
    "empty?"
    "environment-variables-copy"
    "environment-variables-names"
    "environment-variables-ref"
    "environment-variables-set!"
    "environment-variables?"
    "eof"
    "eof-evt"
    "eof-object?"
    "ephemeron-value"
    "ephemeron?"
    "eprintf"
    "eq-contract-val"
    "eq-contract?"
    "eq-hash-code"
    "eq?"
    "equal-contract-val"
    "equal-contract?"
    "equal-hash-code"
    "equal-secondary-hash-code"
    "equal<%>"
    "equal?"
    "equal?/recur"
    "eqv-hash-code"
    "eqv?"
    "error"
    "error-display-handler"
    "error-escape-handler"
    "error-print-context-length"
    "error-print-source-location"
    "error-print-width"
    "error-value->string-handler"
    "eval"
    "eval-jit-enabled"
    "eval-syntax"
    "even?"
    "evt/c"
    "evt?"
    "exact->inexact"
    "exact-ceiling"
    "exact-floor"
    "exact-integer?"
    "exact-nonnegative-integer?"
    "exact-positive-integer?"
    "exact-round"
    "exact-truncate"
    "exact?"
    "except"
    "executable-yield-handler"
    "exit"
    "exit-handler"
    "exn-continuation-marks"
    "exn-message"
    "exn:break-continuation"
    "exn:break:hang-up?"
    "exn:break:terminate?"
    "exn:break?"
    "exn:fail:contract:arity?"
    "exn:fail:contract:blame"
    "exn:fail:contract:blame-object"
    "exn:fail:contract:blame?"
    "exn:fail:contract:continuation?"
    "exn:fail:contract:divide-by-zero?"
    "exn:fail:contract:non-fixnum-result?"
    "exn:fail:contract:variable-id"
    "exn:fail:contract:variable?"
    "exn:fail:contract?"
    "exn:fail:filesystem:errno-errno"
    "exn:fail:filesystem:errno?"
    "exn:fail:filesystem:exists?"
    "exn:fail:filesystem:missing-module-path"
    "exn:fail:filesystem:missing-module?"
    "exn:fail:filesystem:version?"
    "exn:fail:filesystem?"
    "exn:fail:network:errno-errno"
    "exn:fail:network:errno?"
    "exn:fail:network?"
    "exn:fail:object"
    "exn:fail:object?"
    "exn:fail:out-of-memory?"
    "exn:fail:read-srclocs"
    "exn:fail:read:eof?"
    "exn:fail:read:non-char?"
    "exn:fail:read?"
    "exn:fail:syntax-exprs"
    "exn:fail:syntax:missing-module-path"
    "exn:fail:syntax:missing-module?"
    "exn:fail:syntax:unbound?"
    "exn:fail:syntax?"
    "exn:fail:unsupported?"
    "exn:fail:user?"
    "exn:fail?"
    "exn:misc:match?"
    "exn:missing-module-accessor"
    "exn:missing-module?"
    "exn:srclocs-accessor"
    "exn:srclocs?"
    "exn?"
    "exp"
    "expand"
    "expand-once"
    "expand-syntax"
    "expand-syntax-once"
    "expand-syntax-to-top-form"
    "expand-to-top-form"
    "expand-user-path"
    "explode-path"
    "export"
    "expt"
    "extends"
    "externalizable<%>"
    "failure-cont"
    "failure-result/c"
    "false"
    "false/c"
    "false?"
    "field"
    "field-bound?"
    "field-names"
    "fifth"
    "file->bytes"
    "file->bytes-lines"
    "file->lines"
    "file->list"
    "file->string"
    "file->value"
    "file-exists?"
    "file-name-from-path"
    "file-or-directory-identity"
    "file-or-directory-modify-seconds"
    "file-or-directory-permissions"
    "file-or-directory-type"
    "file-position"
    "file-position*"
    "file-size"
    "file-stream-buffer-mode"
    "file-stream-port?"
    "file-truncate"
    "filename-extension"
    "filesystem-change-evt"
    "filesystem-change-evt-cancel"
    "filesystem-change-evt?"
    "filesystem-root-list"
    "filter"
    "filter-map"
    "filter-not"
    "filter-read-input-port"
    "find-compiled-file-roots"
    "find-executable-path"
    "find-files"
    "find-library-collection-links"
    "find-library-collection-paths"
    "find-relative-path"
    "find-system-path"
    "findf"
    "first"
    "first-or/c"
    "fixnum?"
    "flat-contract"
    "flat-contract-predicate"
    "flat-contract-property?"
    "flat-contract-with-explanation"
    "flat-contract?"
    "flat-murec-contract"
    "flat-named-contract"
    "flat-rec-contract"
    "flatten"
    "floating-point-bytes->real"
    "flonum?"
    "floor"
    "flush-output"
    "fold-files"
    "foldl"
    "foldr"
    "for*/and:"
    "for*/async"
    "for*/extflvector:"
    "for*/first:"
    "for*/flvector:"
    "for*/fold:"
    "for*/foldr:"
    "for*/hash:"
    "for*/hasheq:"
    "for*/hasheqv:"
    "for*/last:"
    "for*/list:"
    "for*/lists:"
    "for*/mutable-set"
    "for*/mutable-seteq"
    "for*/mutable-seteqv"
    "for*/or:"
    "for*/product:"
    "for*/set"
    "for*/set:"
    "for*/seteq"
    "for*/seteqv"
    "for*/stream"
    "for*/sum:"
    "for*/vector:"
    "for*/weak-set"
    "for*/weak-seteq"
    "for*/weak-seteqv"
    "for*:"
    "for-clause-syntax-protect"
    "for-each"
    "for/and:"
    "for/async"
    "for/extflvector:"
    "for/first:"
    "for/flvector:"
    "for/fold:"
    "for/foldr:"
    "for/hash:"
    "for/hasheq:"
    "for/hasheqv:"
    "for/last:"
    "for/list:"
    "for/lists:"
    "for/mutable-set"
    "for/mutable-seteq"
    "for/mutable-seteqv"
    "for/or:"
    "for/product:"
    "for/set"
    "for/set:"
    "for/seteq"
    "for/seteqv"
    "for/stream"
    "for/sum:"
    "for/vector:"
    "for/weak-set"
    "for/weak-seteq"
    "for/weak-seteqv"
    "for:"
    "force"
    "format"
    "format-id"
    "format-symbol"
    "fourth"
    "fprintf"
    "free-identifier=?"
    "free-label-identifier=?"
    "free-template-identifier=?"
    "free-transformer-identifier=?"
    "fsemaphore-count"
    "fsemaphore-post"
    "fsemaphore-try-wait?"
    "fsemaphore-wait"
    "fsemaphore?"
    "future"
    "future?"
    "futures-enabled?"
    "gcd"
    "gen:dict"
    "gen:set"
    "gen:stream"
    "generate-member-key"
    "generate-temporaries"
    "generate-temporary"
    "generic"
    "generic-set?"
    "generic?"
    "gensym"
    "get-field"
    "get-output-bytes"
    "get-output-string"
    "get-preference"
    "get/build-late-neg-projection"
    "get/build-val-first-projection"
    "getenv"
    "global-port-print-handler"
    "group-by"
    "group-execute-bit"
    "group-read-bit"
    "group-write-bit"
    "guard-evt"
    "handle-evt"
    "handle-evt?"
    "has-blame?"
    "has-contract?"
    "hash"
    "hash->list"
    "hash-clear"
    "hash-clear!"
    "hash-copy"
    "hash-copy-clear"
    "hash-count"
    "hash-empty?"
    "hash-ephemeron?"
    "hash-eq?"
    "hash-equal?"
    "hash-eqv?"
    "hash-for-each"
    "hash-has-key?"
    "hash-iterate-first"
    "hash-iterate-key"
    "hash-iterate-key+value"
    "hash-iterate-next"
    "hash-iterate-pair"
    "hash-iterate-value"
    "hash-keys"
    "hash-keys-subset?"
    "hash-map"
    "hash-placeholder?"
    "hash-ref"
    "hash-ref!"
    "hash-ref-key"
    "hash-remove"
    "hash-remove!"
    "hash-set"
    "hash-set!"
    "hash-set*"
    "hash-set*!"
    "hash-strong?"
    "hash-update"
    "hash-update!"
    "hash-values"
    "hash-weak?"
    "hash/c"
    "hash/dc"
    "hash?"
    "hasheq"
    "hasheqv"
    "identifier-binding"
    "identifier-binding-symbol"
    "identifier-label-binding"
    "identifier-prune-lexical-context"
    "identifier-prune-to-source-module"
    "identifier-remove-from-definition-context"
    "identifier-template-binding"
    "identifier-transformer-binding"
    "identifier?"
    "identity"
    "if/c"
    "imag-part"
    "immutable?"
    "impersonate-box"
    "impersonate-channel"
    "impersonate-continuation-mark-key"
    "impersonate-hash"
    "impersonate-hash-set"
    "impersonate-procedure"
    "impersonate-procedure*"
    "impersonate-prompt-tag"
    "impersonate-struct"
    "impersonate-vector"
    "impersonate-vector*"
    "impersonator-contract?"
    "impersonator-ephemeron"
    "impersonator-of?"
    "impersonator-prop:application-mark"
    "impersonator-prop:blame"
    "impersonator-prop:contracted"
    "impersonator-property-accessor-procedure?"
    "impersonator-property?"
    "impersonator?"
    "implementation?"
    "implementation?/c"
    "implies"
    "import"
    "in-combinations"
    "in-cycle"
    "in-dict"
    "in-dict-keys"
    "in-dict-pairs"
    "in-dict-values"
    "in-immutable-set"
    "in-mutable-set"
    "in-parallel"
    "in-permutations"
    "in-sequences"
    "in-set"
    "in-slice"
    "in-stream"
    "in-syntax"
    "in-values*-sequence"
    "in-values-sequence"
    "in-weak-set"
    "include"
    "include-at/relative-to"
    "include-at/relative-to/reader"
    "include/reader"
    "inclusive-range"
    "index-of"
    "index-where"
    "index?"
    "indexes-of"
    "indexes-where"
    "inexact->exact"
    "inexact-real?"
    "inexact?"
    "infinite?"
    "inherit"
    "inherit-field"
    "inherit/inner"
    "inherit/super"
    "init"
    "init-depend"
    "init-field"
    "init-rest"
    "inner"
    "input-port-append"
    "input-port?"
    "inspect"
    "inspector-superior?"
    "inspector?"
    "inst"
    "instanceof/c"
    "instantiate"
    "integer->char"
    "integer->integer-bytes"
    "integer-bytes->integer"
    "integer-in"
    "integer-length"
    "integer-sqrt"
    "integer-sqrt/remainder"
    "integer?"
    "interactive-command-procedure"
    "interactive-command?"
    "interface"
    "interface*"
    "interface->method-names"
    "interface-extension?"
    "interface?"
    "internal-definition-context-apply"
    "internal-definition-context-binding-identifiers"
    "internal-definition-context-introduce"
    "internal-definition-context-seal"
    "internal-definition-context?"
    "invariant-assertion"
    "invoke-unit"
    "invoke-unit/infer"
    "is-a?"
    "is-a?/c"
    "keyword->string"
    "keyword-apply"
    "keyword-apply/dict"
    "keyword<?"
    "keyword?"
    "keywords-match"
    "kill-thread"
    "lambda:"
    "last"
    "last-pair"
    "lazy"
    "lcm"
    "legacy-match-expander?"
    "length"
    "let*-values:"
    "let*:"
    "let-values:"
    "let/cc:"
    "let/ec:"
    "let:"
    "letrec-values:"
    "letrec:"
    "liberal-define-context?"
    "link"
    "link-exists?"
    "list"
    "list*"
    "list*of"
    "list->bytes"
    "list->mutable-set"
    "list->mutable-seteq"
    "list->mutable-seteqv"
    "list->set"
    "list->seteq"
    "list->seteqv"
    "list->string"
    "list->vector"
    "list->weak-set"
    "list->weak-seteq"
    "list->weak-seteqv"
    "list-contract?"
    "list-prefix?"
    "list-ref"
    "list-set"
    "list-tail"
    "list-update"
    "list/c"
    "list?"
    "listen-port-number?"
    "listof"
    "load"
    "load-extension"
    "load-on-demand-enabled"
    "load-relative"
    "load-relative-extension"
    "load/cd"
    "load/use-compiled"
    "local"
    "local-expand"
    "local-expand/capture-lifts"
    "local-transformer-expand"
    "local-transformer-expand/capture-lifts"
    "locale-string-encoding"
    "log"
    "log-all-levels"
    "log-level-evt"
    "log-level?"
    "log-max-level"
    "log-message"
    "log-receiver?"
    "logger-name"
    "logger?"
    "magnitude"
    "make-arity-at-least"
    "make-base-empty-namespace"
    "make-base-namespace"
    "make-bytes"
    "make-channel"
    "make-chaperone-contract"
    "make-continuation-mark-key"
    "make-continuation-prompt-tag"
    "make-contract"
    "make-custodian"
    "make-custodian-box"
    "make-custom-hash"
    "make-custom-hash-types"
    "make-custom-set"
    "make-custom-set-types"
    "make-date"
    "make-date*"
    "make-derived-parameter"
    "make-directory"
    "make-directory*"
    "make-do-sequence"
    "make-empty-namespace"
    "make-environment-variables"
    "make-ephemeron"
    "make-ephemeron-hash"
    "make-ephemeron-hasheq"
    "make-ephemeron-hasheqv"
    "make-exn"
    "make-exn:break"
    "make-exn:break:hang-up"
    "make-exn:break:terminate"
    "make-exn:fail"
    "make-exn:fail:contract"
    "make-exn:fail:contract:arity"
    "make-exn:fail:contract:blame"
    "make-exn:fail:contract:continuation"
    "make-exn:fail:contract:divide-by-zero"
    "make-exn:fail:contract:non-fixnum-result"
    "make-exn:fail:contract:variable"
    "make-exn:fail:filesystem"
    "make-exn:fail:filesystem:errno"
    "make-exn:fail:filesystem:exists"
    "make-exn:fail:filesystem:missing-module"
    "make-exn:fail:filesystem:version"
    "make-exn:fail:network"
    "make-exn:fail:network:errno"
    "make-exn:fail:object"
    "make-exn:fail:out-of-memory"
    "make-exn:fail:read"
    "make-exn:fail:read:eof"
    "make-exn:fail:read:non-char"
    "make-exn:fail:syntax"
    "make-exn:fail:syntax:missing-module"
    "make-exn:fail:syntax:unbound"
    "make-exn:fail:unsupported"
    "make-exn:fail:user"
    "make-file-or-directory-link"
    "make-flat-contract"
    "make-fsemaphore"
    "make-generic"
    "make-handle-get-preference-locked"
    "make-hash"
    "make-hash-placeholder"
    "make-hasheq"
    "make-hasheq-placeholder"
    "make-hasheqv"
    "make-hasheqv-placeholder"
    "make-immutable-custom-hash"
    "make-immutable-hash"
    "make-immutable-hasheq"
    "make-immutable-hasheqv"
    "make-impersonator-property"
    "make-input-port"
    "make-input-port/read-to-peek"
    "make-inspector"
    "make-interned-syntax-introducer"
    "make-keyword-procedure")
  "Racket \"builtins\": extra from #lang racket and #lang typed/racket")

(defconst racket-builtins-2-of-2
  ;; This list was generated using keywords.rkt -- don't edit
  ;; individual items here!
  '("make-known-char-range-list"
    "make-limited-input-port"
    "make-list"
    "make-lock-file-name"
    "make-log-receiver"
    "make-logger"
    "make-mixin-contract"
    "make-mutable-custom-set"
    "make-none/c"
    "make-object"
    "make-output-port"
    "make-parameter"
    "make-parent-directory*"
    "make-phantom-bytes"
    "make-pipe"
    "make-pipe-with-specials"
    "make-placeholder"
    "make-plumber"
    "make-polar"
    "make-predicate"
    "make-prefab-struct"
    "make-primitive-class"
    "make-proj-contract"
    "make-pseudo-random-generator"
    "make-reader-graph"
    "make-readtable"
    "make-rectangular"
    "make-rename-transformer"
    "make-resolved-module-path"
    "make-security-guard"
    "make-semaphore"
    "make-set!-transformer"
    "make-shared-bytes"
    "make-sibling-inspector"
    "make-special-comment"
    "make-srcloc"
    "make-string"
    "make-struct-field-accessor"
    "make-struct-field-mutator"
    "make-struct-type"
    "make-struct-type-property"
    "make-syntax-delta-introducer"
    "make-syntax-introducer"
    "make-temporary-file"
    "make-tentative-pretty-print-output-port"
    "make-thread-cell"
    "make-thread-group"
    "make-vector"
    "make-weak-box"
    "make-weak-custom-hash"
    "make-weak-custom-set"
    "make-weak-hash"
    "make-weak-hasheq"
    "make-weak-hasheqv"
    "make-will-executor"
    "map"
    "match"
    "match*"
    "match*/derived"
    "match-...-nesting"
    "match-define"
    "match-define-values"
    "match-equality-test"
    "match-expander?"
    "match-lambda"
    "match-lambda*"
    "match-lambda**"
    "match-let"
    "match-let*"
    "match-let*-values"
    "match-let-values"
    "match-letrec"
    "match-letrec-values"
    "match/derived"
    "match/values"
    "matches-arity-exactly?"
    "max"
    "mcar"
    "mcdr"
    "mcons"
    "member"
    "member-name-key"
    "member-name-key-hash-code"
    "member-name-key=?"
    "member-name-key?"
    "memf"
    "memory-order-acquire"
    "memory-order-release"
    "memq"
    "memv"
    "merge-input"
    "method-in-interface?"
    "min"
    "mixin"
    "mixin-contract"
    "module->exports"
    "module->imports"
    "module->indirect-exports"
    "module->language-info"
    "module->namespace"
    "module-compiled-cross-phase-persistent?"
    "module-compiled-exports"
    "module-compiled-imports"
    "module-compiled-indirect-exports"
    "module-compiled-language-info"
    "module-compiled-name"
    "module-compiled-submodules"
    "module-declared?"
    "module-path-index-join"
    "module-path-index-resolve"
    "module-path-index-split"
    "module-path-index-submodule"
    "module-path-index?"
    "module-path?"
    "module-predefined?"
    "module-provide-protected?"
    "modulo"
    "mpair?"
    "mu"
    "mutable-set"
    "mutable-seteq"
    "mutable-seteqv"
    "n->th"
    "nack-guard-evt"
    "namespace-anchor->empty-namespace"
    "namespace-anchor->namespace"
    "namespace-anchor?"
    "namespace-attach-module"
    "namespace-attach-module-declaration"
    "namespace-base-phase"
    "namespace-call-with-registry-lock"
    "namespace-mapped-symbols"
    "namespace-module-identifier"
    "namespace-module-registry"
    "namespace-require"
    "namespace-require/constant"
    "namespace-require/copy"
    "namespace-require/expansion-time"
    "namespace-set-variable-value!"
    "namespace-symbol->identifier"
    "namespace-syntax-introduce"
    "namespace-undefine-variable!"
    "namespace-unprotect-module"
    "namespace-variable-value"
    "namespace?"
    "nan?"
    "nand"
    "natural-number/c"
    "natural?"
    "negate"
    "negative-integer?"
    "negative?"
    "never-evt"
    "new"
    "new-∀/c"
    "new-∃/c"
    "newline"
    "ninth"
    "non-empty-listof"
    "non-empty-string?"
    "none/c"
    "nonnegative-integer?"
    "nonpositive-integer?"
    "nor"
    "normal-case-path"
    "normalize-arity"
    "normalize-path"
    "normalized-arity?"
    "not"
    "not/c"
    "null"
    "null?"
    "number->string"
    "number?"
    "numerator"
    "object%"
    "object->vector"
    "object-contract"
    "object-info"
    "object-interface"
    "object-method-arity-includes?"
    "object-name"
    "object-or-false=?"
    "object/c"
    "object=-hash-code"
    "object=?"
    "object?"
    "odd?"
    "one-of/c"
    "only"
    "open"
    "open-input-bytes"
    "open-input-string"
    "open-output-bytes"
    "open-output-nowhere"
    "open-output-string"
    "opt-lambda:"
    "opt/c"
    "or/c"
    "order-of-magnitude"
    "ormap"
    "other-execute-bit"
    "other-read-bit"
    "other-write-bit"
    "output-port?"
    "overment"
    "overment*"
    "override"
    "override*"
    "override-final"
    "override-final*"
    "pair?"
    "parameter-procedure=?"
    "parameter/c"
    "parameter?"
    "parameterization?"
    "parametric->/c"
    "parse-command-line"
    "partition"
    "path->bytes"
    "path->complete-path"
    "path->directory-path"
    "path->string"
    "path-add-extension"
    "path-add-suffix"
    "path-convention-type"
    "path-element->bytes"
    "path-element->string"
    "path-element?"
    "path-for-some-system?"
    "path-get-extension"
    "path-has-extension?"
    "path-list-string->path-list"
    "path-only"
    "path-replace-extension"
    "path-replace-suffix"
    "path-string?"
    "path<?"
    "path?"
    "pathlist-closure"
    "pcase-lambda:"
    "pdefine:"
    "peek-byte"
    "peek-byte-or-special"
    "peek-bytes"
    "peek-bytes!"
    "peek-bytes!-evt"
    "peek-bytes-avail!"
    "peek-bytes-avail!*"
    "peek-bytes-avail!-evt"
    "peek-bytes-avail!/enable-break"
    "peek-bytes-evt"
    "peek-char"
    "peek-char-or-special"
    "peek-string"
    "peek-string!"
    "peek-string!-evt"
    "peek-string-evt"
    "peeking-input-port"
    "permutations"
    "phantom-bytes?"
    "pi"
    "pi.f"
    "pipe-content-length"
    "place"
    "place*"
    "place-break"
    "place-channel"
    "place-channel-get"
    "place-channel-put"
    "place-channel-put/get"
    "place-channel?"
    "place-dead-evt"
    "place-enabled?"
    "place-kill"
    "place-location?"
    "place-message-allowed?"
    "place-wait"
    "place/context"
    "place?"
    "placeholder-get"
    "placeholder-set!"
    "placeholder?"
    "plambda:"
    "plet:"
    "plumber-add-flush!"
    "plumber-flush-all"
    "plumber-flush-handle-remove!"
    "plumber-flush-handle?"
    "plumber?"
    "poll-guard-evt"
    "popt-lambda:"
    "port->bytes"
    "port->bytes-lines"
    "port->lines"
    "port->list"
    "port->string"
    "port-closed-evt"
    "port-closed?"
    "port-commit-peeked"
    "port-count-lines!"
    "port-count-lines-enabled"
    "port-counts-lines?"
    "port-display-handler"
    "port-file-identity"
    "port-file-unlock"
    "port-next-location"
    "port-number?"
    "port-print-handler"
    "port-progress-evt"
    "port-provides-progress-evts?"
    "port-read-handler"
    "port-try-file-lock?"
    "port-waiting-peer?"
    "port-write-handler"
    "port-writes-atomic?"
    "port-writes-special?"
    "port?"
    "positive-integer?"
    "positive?"
    "pred"
    "predicate/c"
    "prefab-key->struct-type"
    "prefab-key?"
    "prefab-struct-key"
    "preferences-lock-file-mode"
    "prefix"
    "pregexp"
    "pregexp?"
    "pretty-display"
    "pretty-format"
    "pretty-print"
    "pretty-print-.-symbol-without-bars"
    "pretty-print-abbreviate-read-macros"
    "pretty-print-columns"
    "pretty-print-current-style-table"
    "pretty-print-depth"
    "pretty-print-exact-as-decimal"
    "pretty-print-extend-style-table"
    "pretty-print-handler"
    "pretty-print-newline"
    "pretty-print-post-print-hook"
    "pretty-print-pre-print-hook"
    "pretty-print-print-hook"
    "pretty-print-print-line"
    "pretty-print-remap-stylable"
    "pretty-print-show-inexactness"
    "pretty-print-size-hook"
    "pretty-print-style-table?"
    "pretty-printing"
    "pretty-write"
    "primitive-closure?"
    "primitive-result-arity"
    "primitive?"
    "print"
    "print-as-expression"
    "print-boolean-long-form"
    "print-box"
    "print-graph"
    "print-hash-table"
    "print-mpair-curly-braces"
    "print-pair-curly-braces"
    "print-reader-abbreviations"
    "print-struct"
    "print-syntax-width"
    "print-unreadable"
    "print-value-columns"
    "print-vector-length"
    "printable/c"
    "printable<%>"
    "printf"
    "println"
    "private"
    "private*"
    "procedure->method"
    "procedure-arity"
    "procedure-arity-includes/c"
    "procedure-arity-includes?"
    "procedure-arity-mask"
    "procedure-arity?"
    "procedure-closure-contents-eq?"
    "procedure-extract-target"
    "procedure-impersonator*?"
    "procedure-keywords"
    "procedure-reduce-arity"
    "procedure-reduce-arity-mask"
    "procedure-reduce-keyword-arity"
    "procedure-reduce-keyword-arity-mask"
    "procedure-rename"
    "procedure-result-arity"
    "procedure-specialize"
    "procedure-struct-type?"
    "procedure?"
    "process"
    "process*"
    "process*/ports"
    "process/ports"
    "processor-count"
    "progress-evt?"
    "promise-forced?"
    "promise-running?"
    "promise/c"
    "promise/name?"
    "promise?"
    "prompt-tag/c"
    "prop:arity-string"
    "prop:arrow-contract"
    "prop:arrow-contract-get-info"
    "prop:arrow-contract?"
    "prop:authentic"
    "prop:blame"
    "prop:chaperone-contract"
    "prop:checked-procedure"
    "prop:contract"
    "prop:contracted"
    "prop:custom-print-quotable"
    "prop:custom-write"
    "prop:dict"
    "prop:dict/contract"
    "prop:equal+hash"
    "prop:evt"
    "prop:exn:missing-module"
    "prop:exn:srclocs"
    "prop:expansion-contexts"
    "prop:flat-contract"
    "prop:impersonator-of"
    "prop:input-port"
    "prop:legacy-match-expander"
    "prop:liberal-define-context"
    "prop:match-expander"
    "prop:object-name"
    "prop:orc-contract"
    "prop:orc-contract-get-subcontracts"
    "prop:orc-contract?"
    "prop:output-port"
    "prop:place-location"
    "prop:procedure"
    "prop:recursive-contract"
    "prop:recursive-contract-unroll"
    "prop:recursive-contract?"
    "prop:rename-transformer"
    "prop:sealed"
    "prop:sequence"
    "prop:set!-transformer"
    "prop:stream"
    "proper-subset?"
    "property/c"
    "provide-signature-elements"
    "provide/contract"
    "provide:"
    "pseudo-random-generator->vector"
    "pseudo-random-generator-vector?"
    "pseudo-random-generator?"
    "public"
    "public*"
    "public-final"
    "public-final*"
    "pubment"
    "pubment*"
    "put-preferences"
    "putenv"
    "quotient"
    "quotient/remainder"
    "radians->degrees"
    "raise"
    "raise-argument-error"
    "raise-arguments-error"
    "raise-arity-error"
    "raise-arity-mask-error"
    "raise-blame-error"
    "raise-contract-error"
    "raise-mismatch-error"
    "raise-not-cons-blame-error"
    "raise-range-error"
    "raise-result-arity-error"
    "raise-result-error"
    "raise-syntax-error"
    "raise-type-error"
    "raise-user-error"
    "random"
    "random-seed"
    "range"
    "rational?"
    "rationalize"
    "read"
    "read-accept-bar-quote"
    "read-accept-box"
    "read-accept-compiled"
    "read-accept-dot"
    "read-accept-graph"
    "read-accept-infix-dot"
    "read-accept-lang"
    "read-accept-quasiquote"
    "read-accept-reader"
    "read-byte"
    "read-byte-or-special"
    "read-bytes"
    "read-bytes!"
    "read-bytes!-evt"
    "read-bytes-avail!"
    "read-bytes-avail!*"
    "read-bytes-avail!-evt"
    "read-bytes-avail!/enable-break"
    "read-bytes-evt"
    "read-bytes-line"
    "read-bytes-line-evt"
    "read-case-sensitive"
    "read-cdot"
    "read-char"
    "read-char-or-special"
    "read-curly-brace-as-paren"
    "read-curly-brace-with-tag"
    "read-decimal-as-inexact"
    "read-eval-print-loop"
    "read-language"
    "read-line"
    "read-line-evt"
    "read-on-demand-source"
    "read-single-flonum"
    "read-square-bracket-as-paren"
    "read-square-bracket-with-tag"
    "read-string"
    "read-string!"
    "read-string!-evt"
    "read-string-evt"
    "read-syntax"
    "read-syntax/recursive"
    "read/recursive"
    "readtable-mapping"
    "readtable?"
    "real->decimal-string"
    "real->double-flonum"
    "real->floating-point-bytes"
    "real->single-flonum"
    "real-in"
    "real-part"
    "real?"
    "recontract-out"
    "record-disappeared-uses"
    "recursive-contract"
    "reencode-input-port"
    "reencode-output-port"
    "regexp"
    "regexp-match"
    "regexp-match-evt"
    "regexp-match-exact?"
    "regexp-match-peek"
    "regexp-match-peek-immediate"
    "regexp-match-peek-positions"
    "regexp-match-peek-positions-immediate"
    "regexp-match-peek-positions-immediate/end"
    "regexp-match-peek-positions/end"
    "regexp-match-positions"
    "regexp-match-positions/end"
    "regexp-match/end"
    "regexp-match?"
    "regexp-max-lookbehind"
    "regexp-quote"
    "regexp-replace"
    "regexp-replace*"
    "regexp-replace-quote"
    "regexp-replaces"
    "regexp-split"
    "regexp-try-match"
    "regexp?"
    "relative-path?"
    "relocate-input-port"
    "relocate-output-port"
    "remainder"
    "remf"
    "remf*"
    "remove"
    "remove*"
    "remove-duplicates"
    "remq"
    "remq*"
    "remv"
    "remv*"
    "rename"
    "rename-contract"
    "rename-file-or-directory"
    "rename-inner"
    "rename-super"
    "rename-transformer-target"
    "rename-transformer?"
    "replace-evt"
    "require-typed-struct"
    "require-typed-struct/provide"
    "require/opaque-type"
    "require/typed"
    "require/typed/provide"
    "reroot-path"
    "resolve-path"
    "resolved-module-path-name"
    "resolved-module-path?"
    "rest"
    "reverse"
    "round"
    "row-inst"
    "second"
    "seconds->date"
    "security-guard?"
    "semaphore-peek-evt"
    "semaphore-peek-evt?"
    "semaphore-post"
    "semaphore-try-wait?"
    "semaphore-wait"
    "semaphore-wait/enable-break"
    "semaphore?"
    "send"
    "send*"
    "send+"
    "send-generic"
    "send/apply"
    "send/keyword-apply"
    "sequence->list"
    "sequence->stream"
    "sequence-add-between"
    "sequence-andmap"
    "sequence-append"
    "sequence-count"
    "sequence-filter"
    "sequence-fold"
    "sequence-for-each"
    "sequence-generate"
    "sequence-generate*"
    "sequence-length"
    "sequence-map"
    "sequence-ormap"
    "sequence-ref"
    "sequence-tail"
    "sequence/c"
    "sequence?"
    "set"
    "set!-transformer-procedure"
    "set!-transformer?"
    "set->list"
    "set->stream"
    "set-add"
    "set-add!"
    "set-box!"
    "set-box*!"
    "set-clear"
    "set-clear!"
    "set-copy"
    "set-copy-clear"
    "set-count"
    "set-empty?"
    "set-eq?"
    "set-equal?"
    "set-eqv?"
    "set-field!"
    "set-first"
    "set-for-each"
    "set-implements/c"
    "set-implements?"
    "set-intersect"
    "set-intersect!"
    "set-map"
    "set-mcar!"
    "set-mcdr!"
    "set-member?"
    "set-mutable?"
    "set-phantom-bytes!"
    "set-port-next-location!"
    "set-remove"
    "set-remove!"
    "set-rest"
    "set-subtract"
    "set-subtract!"
    "set-symmetric-difference"
    "set-symmetric-difference!"
    "set-union"
    "set-union!"
    "set-weak?"
    "set/c"
    "set=?"
    "set?"
    "seteq"
    "seteqv"
    "seventh"
    "sgn"
    "sha1-bytes"
    "sha224-bytes"
    "sha256-bytes"
    "shared"
    "shared-bytes"
    "shell-execute"
    "shrink-path-wrt"
    "shuffle"
    "simple-form-path"
    "simplify-path"
    "sin"
    "single-flonum-available?"
    "single-flonum?"
    "sinh"
    "sixth"
    "skip-projection-wrapper?"
    "sleep"
    "some-system-path->string"
    "special-comment-value"
    "special-comment?"
    "special-filter-input-port"
    "split-at"
    "split-at-right"
    "split-common-prefix"
    "split-path"
    "splitf-at"
    "splitf-at-right"
    "sqr"
    "sqrt"
    "srcloc->string"
    "srcloc-column"
    "srcloc-line"
    "srcloc-position"
    "srcloc-source"
    "srcloc-span"
    "srcloc?"
    "stop-after"
    "stop-before"
    "stream"
    "stream*"
    "stream->list"
    "stream-add-between"
    "stream-andmap"
    "stream-append"
    "stream-cons"
    "stream-count"
    "stream-empty?"
    "stream-filter"
    "stream-first"
    "stream-fold"
    "stream-for-each"
    "stream-force"
    "stream-lazy"
    "stream-length"
    "stream-map"
    "stream-ormap"
    "stream-ref"
    "stream-rest"
    "stream-tail"
    "stream-take"
    "stream/c"
    "stream?"
    "string"
    "string->bytes/latin-1"
    "string->bytes/locale"
    "string->bytes/utf-8"
    "string->immutable-string"
    "string->keyword"
    "string->list"
    "string->number"
    "string->path"
    "string->path-element"
    "string->some-system-path"
    "string->symbol"
    "string->uninterned-symbol"
    "string->unreadable-symbol"
    "string-append"
    "string-append*"
    "string-append-immutable"
    "string-ci<=?"
    "string-ci<?"
    "string-ci=?"
    "string-ci>=?"
    "string-ci>?"
    "string-contains?"
    "string-copy"
    "string-copy!"
    "string-downcase"
    "string-environment-variable-name?"
    "string-fill!"
    "string-foldcase"
    "string-join"
    "string-len/c"
    "string-length"
    "string-locale-ci<?"
    "string-locale-ci=?"
    "string-locale-ci>?"
    "string-locale-downcase"
    "string-locale-upcase"
    "string-locale<?"
    "string-locale=?"
    "string-locale>?"
    "string-no-nuls?"
    "string-normalize-nfc"
    "string-normalize-nfd"
    "string-normalize-nfkc"
    "string-normalize-nfkd"
    "string-normalize-spaces"
    "string-port?"
    "string-prefix?"
    "string-ref"
    "string-replace"
    "string-set!"
    "string-split"
    "string-suffix?"
    "string-titlecase"
    "string-trim"
    "string-upcase"
    "string-utf-8-length"
    "string<=?"
    "string<?"
    "string=?"
    "string>=?"
    "string>?"
    "string?"
    "struct*"
    "struct->vector"
    "struct-accessor-procedure?"
    "struct-constructor-procedure?"
    "struct-guard/c"
    "struct-info"
    "struct-mutator-procedure?"
    "struct-predicate-procedure?"
    "struct-type-authentic?"
    "struct-type-info"
    "struct-type-make-constructor"
    "struct-type-make-predicate"
    "struct-type-property-accessor-procedure?"
    "struct-type-property-predicate-procedure?"
    "struct-type-property/c"
    "struct-type-property?"
    "struct-type-sealed?"
    "struct-type?"
    "struct/c"
    "struct/contract"
    "struct/ctc"
    "struct/dc"
    "struct:"
    "struct:arity-at-least"
    "struct:arrow-contract-info"
    "struct:date"
    "struct:date*"
    "struct:exn"
    "struct:exn:break"
    "struct:exn:break:hang-up"
    "struct:exn:break:terminate"
    "struct:exn:fail"
    "struct:exn:fail:contract"
    "struct:exn:fail:contract:arity"
    "struct:exn:fail:contract:blame"
    "struct:exn:fail:contract:continuation"
    "struct:exn:fail:contract:divide-by-zero"
    "struct:exn:fail:contract:non-fixnum-result"
    "struct:exn:fail:contract:variable"
    "struct:exn:fail:filesystem"
    "struct:exn:fail:filesystem:errno"
    "struct:exn:fail:filesystem:exists"
    "struct:exn:fail:filesystem:missing-module"
    "struct:exn:fail:filesystem:version"
    "struct:exn:fail:network"
    "struct:exn:fail:network:errno"
    "struct:exn:fail:object"
    "struct:exn:fail:out-of-memory"
    "struct:exn:fail:read"
    "struct:exn:fail:read:eof"
    "struct:exn:fail:read:non-char"
    "struct:exn:fail:syntax"
    "struct:exn:fail:syntax:missing-module"
    "struct:exn:fail:syntax:unbound"
    "struct:exn:fail:unsupported"
    "struct:exn:fail:user"
    "struct:srcloc"
    "struct?"
    "sub1"
    "subbytes"
    "subclass?"
    "subclass?/c"
    "subprocess"
    "subprocess-group-enabled"
    "subprocess-kill"
    "subprocess-pid"
    "subprocess-status"
    "subprocess-wait"
    "subprocess?"
    "subset?"
    "substring"
    "suggest/c"
    "super"
    "super-instantiate"
    "super-make-object"
    "super-new"
    "symbol->string"
    "symbol-interned?"
    "symbol-unreadable?"
    "symbol<?"
    "symbol=?"
    "symbol?"
    "symbols"
    "sync"
    "sync/enable-break"
    "sync/timeout"
    "sync/timeout/enable-break"
    "syntax->datum"
    "syntax->list"
    "syntax-arm"
    "syntax-binding-set"
    "syntax-binding-set->syntax"
    "syntax-binding-set?"
    "syntax-column"
    "syntax-debug-info"
    "syntax-disarm"
    "syntax-e"
    "syntax-line"
    "syntax-local-bind-syntaxes"
    "syntax-local-certifier"
    "syntax-local-context"
    "syntax-local-eval"
    "syntax-local-expand-expression"
    "syntax-local-get-shadower"
    "syntax-local-identifier-as-binding"
    "syntax-local-introduce"
    "syntax-local-lift-context"
    "syntax-local-lift-expression"
    "syntax-local-lift-module"
    "syntax-local-lift-module-end-declaration"
    "syntax-local-lift-provide"
    "syntax-local-lift-require"
    "syntax-local-lift-values-expression"
    "syntax-local-make-definition-context"
    "syntax-local-make-delta-introducer"
    "syntax-local-match-introduce"
    "syntax-local-module-defined-identifiers"
    "syntax-local-module-exports"
    "syntax-local-module-required-identifiers"
    "syntax-local-name"
    "syntax-local-phase-level"
    "syntax-local-submodules"
    "syntax-local-transforming-module-provides?"
    "syntax-local-value"
    "syntax-local-value/immediate"
    "syntax-local-value/record"
    "syntax-original?"
    "syntax-parse"
    "syntax-parser"
    "syntax-pattern-variable?"
    "syntax-position"
    "syntax-property"
    "syntax-property-preserved?"
    "syntax-property-remove"
    "syntax-property-symbol-keys"
    "syntax-protect"
    "syntax-rearm"
    "syntax-recertify"
    "syntax-shift-phase-level"
    "syntax-source"
    "syntax-source-module"
    "syntax-span"
    "syntax-taint"
    "syntax-tainted?"
    "syntax-track-origin"
    "syntax-transforming-module-expression?"
    "syntax-transforming-with-lifts?"
    "syntax-transforming?"
    "syntax/c"
    "syntax?"
    "system"
    "system*"
    "system*/exit-code"
    "system-big-endian?"
    "system-idle-evt"
    "system-language+country"
    "system-library-subpath"
    "system-path-convention-type"
    "system-type"
    "system/exit-code"
    "tag"
    "tail-marks-match?"
    "take"
    "take-common-prefix"
    "take-right"
    "takef"
    "takef-right"
    "tan"
    "tanh"
    "tcp-abandon-port"
    "tcp-accept"
    "tcp-accept-evt"
    "tcp-accept-ready?"
    "tcp-accept/enable-break"
    "tcp-addresses"
    "tcp-close"
    "tcp-connect"
    "tcp-connect/enable-break"
    "tcp-listen"
    "tcp-listener?"
    "tcp-port?"
    "tentative-pretty-print-port-cancel"
    "tentative-pretty-print-port-transfer"
    "tenth"
    "terminal-port?"
    "the-unsupplied-arg"
    "third"
    "this"
    "this%"
    "thread"
    "thread-cell-ref"
    "thread-cell-set!"
    "thread-cell-values?"
    "thread-cell?"
    "thread-dead-evt"
    "thread-dead?"
    "thread-group?"
    "thread-receive"
    "thread-receive-evt"
    "thread-resume"
    "thread-resume-evt"
    "thread-rewind-receive"
    "thread-running?"
    "thread-send"
    "thread-suspend"
    "thread-suspend-evt"
    "thread-try-receive"
    "thread-wait"
    "thread/suspend-to-kill"
    "thread?"
    "thunk"
    "thunk*"
    "time-apply"
    "touch"
    "transplant-input-port"
    "transplant-output-port"
    "true"
    "truncate"
    "typecheck-fail"
    "udp-addresses"
    "udp-bind!"
    "udp-bound?"
    "udp-close"
    "udp-connect!"
    "udp-connected?"
    "udp-multicast-interface"
    "udp-multicast-join-group!"
    "udp-multicast-leave-group!"
    "udp-multicast-loopback?"
    "udp-multicast-set-interface!"
    "udp-multicast-set-loopback!"
    "udp-multicast-set-ttl!"
    "udp-multicast-ttl"
    "udp-open-socket"
    "udp-receive!"
    "udp-receive!*"
    "udp-receive!-evt"
    "udp-receive!/enable-break"
    "udp-receive-ready-evt"
    "udp-send"
    "udp-send*"
    "udp-send-evt"
    "udp-send-ready-evt"
    "udp-send-to"
    "udp-send-to*"
    "udp-send-to-evt"
    "udp-send-to/enable-break"
    "udp-send/enable-break"
    "udp-set-receive-buffer-size!"
    "udp-set-ttl!"
    "udp-ttl"
    "udp?"
    "unbox"
    "unbox*"
    "uncaught-exception-handler"
    "unconstrained-domain->"
    "unit"
    "unit-from-context"
    "unit/c"
    "unit/new-import-export"
    "unit/s"
    "unit?"
    "unquoted-printing-string"
    "unquoted-printing-string-value"
    "unquoted-printing-string?"
    "unspecified-dom"
    "unsupplied-arg?"
    "use-collection-link-paths"
    "use-compiled-file-check"
    "use-compiled-file-paths"
    "use-user-specific-search-paths"
    "user-execute-bit"
    "user-read-bit"
    "user-write-bit"
    "value-blame"
    "value-contract"
    "values"
    "values/drop"
    "variable-reference->empty-namespace"
    "variable-reference->module-base-phase"
    "variable-reference->module-declaration-inspector"
    "variable-reference->module-path-index"
    "variable-reference->module-source"
    "variable-reference->namespace"
    "variable-reference->phase"
    "variable-reference->resolved-module-path"
    "variable-reference-constant?"
    "variable-reference-from-unsafe?"
    "variable-reference?"
    "vector"
    "vector*-length"
    "vector*-ref"
    "vector*-set!"
    "vector->immutable-vector"
    "vector->list"
    "vector->pseudo-random-generator"
    "vector->pseudo-random-generator!"
    "vector->values"
    "vector-append"
    "vector-argmax"
    "vector-argmin"
    "vector-cas!"
    "vector-copy"
    "vector-copy!"
    "vector-count"
    "vector-drop"
    "vector-drop-right"
    "vector-empty?"
    "vector-fill!"
    "vector-filter"
    "vector-filter-not"
    "vector-immutable"
    "vector-immutable/c"
    "vector-immutableof"
    "vector-length"
    "vector-map"
    "vector-map!"
    "vector-member"
    "vector-memq"
    "vector-memv"
    "vector-ref"
    "vector-set!"
    "vector-set*!"
    "vector-set-performance-stats!"
    "vector-sort"
    "vector-sort!"
    "vector-split-at"
    "vector-split-at-right"
    "vector-take"
    "vector-take-right"
    "vector/c"
    "vector?"
    "vectorof"
    "version"
    "void"
    "void?"
    "weak-box-value"
    "weak-box?"
    "weak-set"
    "weak-seteq"
    "weak-seteqv"
    "will-execute"
    "will-executor?"
    "will-register"
    "will-try-execute"
    "with-asserts"
    "with-contract"
    "with-contract-continuation-mark"
    "with-disappeared-uses"
    "with-input-from-bytes"
    "with-input-from-string"
    "with-method"
    "with-output-to-bytes"
    "with-output-to-string"
    "with-syntax*"
    "with-type"
    "would-be-future"
    "wrap-evt"
    "writable<%>"
    "write"
    "write-byte"
    "write-bytes"
    "write-bytes-avail"
    "write-bytes-avail*"
    "write-bytes-avail-evt"
    "write-bytes-avail/enable-break"
    "write-char"
    "write-special"
    "write-special-avail*"
    "write-special-evt"
    "write-string"
    "write-to-file"
    "writeln"
    "wrong-syntax"
    "xor"
    "zero?"
    "~.a"
    "~.s"
    "~.v"
    "~a"
    "~e"
    "~r"
    "~s"
    "~v"
    "λ:"
    "→"
    "∀"
    "∩")
  "Racket \"builtins\": extra from #lang racket and #lang typed/racket")

(provide 'racket-keywords-and-builtins)

;; racket-keywords-and-builtins.el ends here
