## RabbitMQ 3.8.2

RabbitMQ `3.8.2` is a maintenance release.

### Erlang/OTP Compatibility Notes

This release [**requires Erlang/OTP 21.3**](https://www.rabbitmq.com/which-erlang.html) or later.
`22.x` series is recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release from `3.7.6` or an older version, extra care has to be taken.

Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded at the same time as Erlang**. Alternatively the node can be upgraded
to `3.7.18` first, then Erlang 21.x or 22.x, then to RabbitMQ 3.8.x.

#### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Enhancements

 * Raft implementation optimizations.

   GitHub issues: [rabbitmq/ra#137](https://github.com/rabbitmq/ra/pull/137), [rabbitmq/ra#148](https://github.com/rabbitmq/ra/pull/148)

 * Quorum queue optimization: enables local (not going through the leader) delivery from Raft followers
   when appropriate and safe.

   GitHub issues: [rabbitmq/rabbitmq-server#2146](https://github.com/rabbitmq/rabbitmq-server/pull/2146), [rabbitmq/ra#132](https://github.com/rabbitmq/ra/pull/132)

 * If `x-queue-type` argument is not provided at queue declaration time, the type is assumed to be `classic`
   instead of missing.

   GitHub issue: [rabbitmq/rabbitmq-common#341](https://github.com/rabbitmq/rabbitmq-common/issues/341)

 * Quorum queue consumer timeout now can be configured using new style configuration file:

   ``` ini
   # Hard timeout for quorum queue consumer acknowledgemnts of two minutes
   consumer_timeout = 120000
   ```

   GitHub issue: [rabbitmq/rabbitmq-server#2163](https://github.com/rabbitmq/rabbitmq-server/pull/2163)

#### Bug Fixes

 * A quorum queue could produce an empty Raft log segment if node is killed at a particular moment in time,
   which would prevent the node from successfully recovering the log after restart.

   GitHub issues: [rabbitmq/ra#138](https://github.com/rabbitmq/ra/pull/138)

 * Quorum queue consumer count metric could be duplicated when reported via HTTP API or to a Prometheus scraper.

   GitHub issue: [rabbitmq/rabbitmq-server#2176](https://github.com/rabbitmq/rabbitmq-server/pull/2176)


### CLI Tools

#### Enhancements

 * It is now possible to [export and import definitions]() without the use of plugins with
   `rabbitmqctl export_definitions` and `rabbitmqctl import_definitions`:

   ``` sh
   # export as a JSON file
   rabbitmqctl export_definitions /path/to/target.file.json

   # export as JSON to standard output and pipe to jq
   rabbitmqctl export_definitions "-" | jq

   # export as a compressed Erlang term file
   rabbitmqctl export_definitions /path/to/target.file --format=erlang

   # learn more
   rabbitmqctl help export_definitions
   ```

   ``` sh
   # import from a JSON file
   rabbitmqctl import_definitions /path/to/target.file.json

   # import JSON from standard input
   cat /path/to/definitions.json | rabbitmqctl import_definitions "-"

   # import from a compressed Erlang term file
   rabbitmqctl import_definitions /path/to/target.file --format=erlang

   # learn more
   rabbitmqctl help import_definitions
   ```

   GitHub issue: [rabbitmq/rabbitmq-management#749](https://github.com/rabbitmq/rabbitmq-management/issues/749)

 * Entities with `amq.*` prefixes are now skipped during import instead of producing an error.

   GitHub issue: [rabbitmq/rabbitmq-server#2170](https://github.com/rabbitmq/rabbitmq-server/issues/2170)

#### Bug Fixes

 * `rabbitmqctl await_startup` failed with an exception when RabbitMQ application was stopped but the
    runtime (Erlang VM) was running.

   GitHub issue: [rabbitmq/rabbitmq-server#2158](https://github.com/rabbitmq/rabbitmq-server/issues/2158)


### Management Plugin

#### Bug Fixes

 * Definition import via HTTP API could fail in if performed via HTTP API (but not management UI)
   and contained operator policies.

   GitHub issue: [rabbitmq/rabbitmq-management#751](https://github.com/rabbitmq/rabbitmq-management/issues/751)

#### Enhancements

 * Metric aggregation optimizations.

   GitHub issue: [rabbitmq/rabbitmq-management-agent#84](https://github.com/rabbitmq/rabbitmq-management-agent/pull/84)


### MQTT Plugin

#### Enhancements

 * Throughput improvements ranging from 14 to 60 percent depending on workload.

   GitHub issue: [rabbitmq/rabbitmq-server#2168](https://github.com/rabbitmq/rabbitmq-server/issues/2168)

 * Throughput improvements and reduced CPU usage but slightly higher per connection RAM footprint.

   GitHub issues: [rabbitmq/rabbitmq-mqtt#216](https://github.com/rabbitmq/rabbitmq-mqtt/pull/216), [rabbitmq/rabbitmq-mqtt#217](https://github.com/rabbitmq/rabbitmq-mqtt/pull/217)

#### Bug Fixes

 * Client ID tracker could produce an empty Raft log segment if node is killed at a particular moment in time,
   which would prevent the node from successfully recovering the log after restart.

   GitHub issues: [rabbitmq/discussions#4](https://github.com/rabbitmq/discussions/issues/4), [rabbitmq/ra#138](https://github.com/rabbitmq/ra/pull/138)

 * Last Will messages that use QoS 2 will now be downgraded to QoS 1 just like with "regular" published messages.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#214](https://github.com/rabbitmq/rabbitmq-mqtt/issues/214)


### AMQP 1.0 Plugin

#### Enhancements

 * Throughput improvements.

   GitHub issue: [rabbitmq/rabbitmq-server#2168](https://github.com/rabbitmq/rabbitmq-server/issues/2168)


### STOMP Plugin

#### Enhancements

 * Throughput improvements.

   GitHub issue: [rabbitmq/rabbitmq-server#2168](https://github.com/rabbitmq/rabbitmq-server/issues/2168)


### Web STOMP Plugin

#### Enhancements

 * Clients now can authenticate using an x.509 (TLS) certificate.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#116](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/116)


### Prometheus Plugin

 * A small number of queue metrics were not read from the metric store correctly.

   GitHub issue: [rabbitmq/rabbitmq-prometheus#19](https://github.com/rabbitmq/rabbitmq-prometheus/issues/19)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.8.2.tar.xz`.
