% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reclass.R
\name{try.xts}
\alias{try.xts}
\alias{use.xts}
\alias{reclass}
\alias{Reclass}
\alias{use.reclass}
\title{Convert Objects to xts and Back to Original Class}
\usage{
try.xts(x, ..., error = TRUE)

reclass(x, match.to, error = FALSE, ...)

Reclass(x)
}
\arguments{
\item{x}{Data object to convert. See details for supported types.}

\item{\dots}{Additional parameters or attributes.}

\item{error}{Error handling option. See Details.}

\item{match.to}{An xts object whose attributes will be copied to the result.}
}
\value{
\code{try.xts()} returns an xts object when conversion is successful.
The \code{error} argument controls the function's behavior when conversion fails.

\code{Reclass()} and \code{reclass()} return the object as its original class, as
specified by the 'CLASS' attribute.
}
\description{
Functions to convert objects of arbitrary classes to xts and then back to
the original class, without losing any attributes of the original class.
}
\details{
A simple and reliable way to convert many different objects into a uniform
format for use within \R.

\code{try.xts()} and \code{reclass()} are functions that enable external developers
access to the reclassing tools within \pkg{xts} to help speed development of
time-aware functions, as well as provide a more robust and seemless end-user
experience, regardless of the end-user's choice of data-classes.

\code{try.xts()} calls \code{as.xts()} internally. See \code{\link[=as.xts]{as.xts()}} for available xts
methods and arguments for each coercible class. Since it calls \code{as.xts()},
you can add custom attributes as \code{name = value} pairs in the same way. But
these custom attributes will not be copied back to the original object when
\code{reclass()} is called.

The \code{error} argument can be a logical value indicating whether an error
should be thrown (or fail silently), a character string allowing for custom
error error messages, or a function of the form \code{f(x, ...)} that will be
called if the conversion fails.

\code{reclass()} converts an object created by \code{try.xts()} back to its original
class with all the original attributes intact (unless they were changed
after the object was converted to xts). The \code{match.to} argument allows you
copy the index attributes (\code{\link{tclass}}, \code{\link{tformat}}, and \code{\link{tzone}}) and
\code{\link[=xtsAttributes]{xtsAttributes()}} from another xts object to the result. \code{match.to} must
be an xts object with an index value for every observation in \code{x}.

\code{Reclass()} is designed for top-level use, where it is desirable to have
the object returned from an arbitrary function in the same class as the
object passed in. Most functions in \R are not designed to return objects
matching the original object's class. It attempts to handle conversion and
reconversion transparently but it requires the original object must be
coercible to xts, the result of the function must have the same number of
rows as the input, and the object to be converted/reclassed must be the
first argument to the function being wrapped. Note that this function
hasn't been tested for robustness.

See the accompanying vignette for more details on the above usage.
}
\examples{

a <- 1:10

# fails silently, the result is still an integer vector
try.xts(a, error = FALSE)

# control the result with a function
try.xts(a, error = function(x, ...) { "I'm afraid I can't do that." })

z <- zoo(1:10, timeBasedSeq("2020-01-01/2020-01-10"))
x <- try.xts(z)  # zoo to xts
str(x)
str(reclass(x))  # reclass back to zoo

}
\seealso{
\code{\link[=as.xts]{as.xts()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
