% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMiss.R
\name{tableMiss}
\alias{tableMiss}
\title{create table with highlighted missings/imputations}
\usage{
tableMiss(x, delimiter = "_imp")
}
\arguments{
\item{x}{a vector, matrix or \code{data.frame}.}

\item{delimiter}{a character-vector to distinguish between variables and
imputation-indices for imputed variables (therefore, \code{x} needs to have
\code{\link[=colnames]{colnames()}}). If given, it is used to determine the corresponding
imputation-index for any imputed variable (a logical-vector indicating which
values of the variable have been imputed). If such imputation-indices are
found, they are used for highlighting and the colors are adjusted according
to the given colors for imputed variables (see \code{col}).}
}
\description{
Create a \code{reactable} table that highlights missing values and imputed values
with the same colors as \code{\link[=histMiss]{histMiss()}}
}
\examples{
data(tao)
x_IMPUTED <- kNN(tao[, c("Air.Temp", "Humidity")])
tableMiss(x_IMPUTED[105:114, ])
x_IMPUTED[106, 2] <- NA
x_IMPUTED[105, 1] <- NA
x_IMPUTED[107, "Humidity_imp"] <- TRUE
tableMiss(x_IMPUTED[105:114, ])
}
