% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations.R
\name{expect_match}
\alias{expect_match}
\title{Match strings to a regular expression}
\usage{
expect_match(current, pattern, info = NA_character_, ...)
}
\arguments{
\item{current}{\code{[character]} String(s) to check for \code{pattern}.}

\item{pattern}{\code{[character]} A regular expression.}

\item{info}{\code{[character]} scalar. Optional user-defined message. Must
be a single character string. Multiline comments may be separated by
\code{"\\n"}.}

\item{...}{passed to \code{\link[base]{grepl}}}
}
\description{
Results in \code{TRUE} only when all elements of current match the regular
expression in \code{pattern}. Matching is done by \code{\link[base]{grepl}}.
}
\examples{
expect_match("hello world", "world")                    # TRUE
expect_match("hello world", "^world$")                  # FALSE
expect_match("HelLO woRlD", "world", ignore.case=TRUE)  # TRUE
expect_match(c("apple","banana"), "a")                  # TRUE
expect_match(c("apple","banana"), "b")                  # FALSE

}
\seealso{
Other test-functions: 
\code{\link{expect_equal_to_reference}()},
\code{\link{expect_equal}()},
\code{\link{expect_length}()},
\code{\link{ignore}()}
}
\concept{test-functions}
