% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{session_diff}
\alias{session_diff}
\title{Compare session information from two sources}
\usage{
session_diff(old = "local", new = "clipboard", ...)
}
\arguments{
\item{old, new}{A \code{session_info} object (the return value of
\code{\link[=session_info]{session_info()}}), or a pointer to \code{\link[=session_info]{session_info()}} output. See details
below.}

\item{...}{Passed to any new \code{\link[=session_info]{session_info()}} calls.}
}
\description{
Compare session information from two sources
}
\details{
Various way to specify \code{old} and \code{new}:
\itemize{
\item A \code{session_info} object.
\item \code{"local"} runs \code{\link[=session_info]{session_info()}} in the current
session, and uses its output.
\item \code{"clipboard"} takes the session info from the system clipboard.
If the clipboard contains a URL, it is followed to download the
session info.
\item A URL starting with \verb{http://} or \verb{https://}. \code{session_diff} searches
the HTML (or text) page for the session info header to find the session
info.
}
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session_diff()
\dontshow{\}) # examplesIf}
}
