% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_coastline.R
\name{ne_coastline}
\alias{ne_coastline}
\title{Get natural earth world coastline}
\usage{
ne_coastline(scale = 110, returnclass = c("sf", "sv"))
}
\arguments{
\item{scale}{The scale of map to return, one of `110`, `50`, `10` or `small`,
`medium`, `large`.}

\item{returnclass}{A string determining the spatial object to return. Either
"sf" for for simple feature (from `sf`, the default) or "sv" for a
`SpatVector` (from `terra`).}
}
\value{
An object of class `sf` for simple feature (from `sf`, the default)
or `SpatVector` (from `terra`).
}
\description{
returns world coastline at specified scale
}
\details{
Note that the filename of the requested object will be returned if
`load = FALSE`.
}
\examples{
if (requireNamespace("rnaturalearthdata")) {
  coast <- ne_coastline()
  plot(coast)
}

}
\seealso{
\code{\link{ne_load}}, pre-downloaded data are available using
  \code{\link{ne_countries}}, \code{\link{ne_states}}. Other geographic data
  are available in the raster package : \code{\link[raster]{getData}}.
}
