% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{render_delayed}
\alias{render_delayed}
\title{Delay Rendering for an Expression}
\usage{
render_delayed(expr)
}
\arguments{
\item{expr}{The expression to evaluate.}
}
\value{
An object representing the expression.
}
\description{
In a Shiny document, evaluate the given expression after the document has
finished rendering, instead of during render.
}
\details{
This function is useful inside Shiny documents. It delays the
evaluation of its argument until the document has finished its initial
render, so that the document can be viewed before the calculation is
finished.

Any expression that returns HTML can be wrapped in \code{render_delayed}.
}
\note{
\code{expr} is evaluated in a \strong{copy} of the environment in which
  the \code{render_delayed} call appears. Consequently, no side effects
  created by \code{expr} are visible in succeeding expressions, nor are
  changes to the environment after the call to \code{render_delayed} visible
  to \code{expr}.

  \code{expr} must be an expression that produces HTML.
}
\examples{
\dontrun{
# Add the following code to an R Markdown document

div(Sys.time())

render_delayed({
 Sys.sleep(3)      # simulate an expensive computation
 div(Sys.time())
})

div(Sys.time())
}
}
