% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R, R/paths.R
\name{packrat-external}
\alias{packrat-external}
\alias{with_extlib}
\alias{extlib}
\alias{user_lib}
\alias{packrat_lib}
\title{Managing External Libraries}
\usage{
with_extlib(packages = NULL, expr, envir = parent.frame())

extlib(packages)

user_lib()

packrat_lib()
}
\arguments{
\item{packages}{An optional set of package names (as a character
vector) to load for the duration of evaluation of \code{expr}.
Whether \code{packages} is provided or \code{NULL} (the
default), \code{expr} is evaluated in an environment where the
external library path is in place, not the local (packrat)
library path.}

\item{expr}{An \R expression.}

\item{envir}{An environment in which the expression is evaluated.}
}
\description{
These functions provide a mechanism for (temporarily) using packages outside
of the packrat private library. The packages are searched within the 'default'
libraries; that is, the libraries that would be available upon launching a new
\R session.
}
\examples{
\dontrun{
with_extlib("lattice", xyplot(1 ~ 1))
with_extlib(expr = packageVersion("lattice"))
# since devtools requires roxygen2 >= 5.0.0 for this step, this
# should fail unless roxygen2 is available in the packrat lib.loc
with_extlib("devtools", load_all("path/to/project"))
# this method will work given roxygen2 is installed in the
# non-packrat lib.loc with devtools
with_extlib(expr = devtools::load_all("path/to/project"))
}
}
