% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastapprox.R
\name{fast.approx}
\alias{fast.approx}
\alias{indexstrata}
\alias{predictCumhaz}
\alias{cpred}
\title{Fast approximation}
\usage{
fast.approx(
  time,
  new.time,
  equal = FALSE,
  type = c("nearest", "right", "left"),
  sorted = FALSE,
  ...
)
}
\arguments{
\item{time}{Original ordered time points}

\item{new.time}{New time points}

\item{equal}{If TRUE a list is returned with additional element}

\item{type}{Type of matching, nearest index, nearest greater than
or equal (right), number of elements smaller than y otherwise
the closest value above new.time is returned.}

\item{sorted}{Set to true if new.time is already sorted}

\item{...}{Optional additional arguments}
}
\description{
Fast approximation
}
\examples{
id <- c(1,1,2,2,7,7,10,10)
fast.approx(unique(id),id)

t <- 0:6
n <- c(-1,0,0.1,0.9,1,1.1,1.2,6,6.5)
fast.approx(t,n,type="left")
}
\author{
Klaus K. Holst
}
