% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostage.R
\name{twostageCV}
\alias{twostageCV}
\title{Cross-validated two-stage estimator}
\usage{
twostageCV(
  model1,
  model2,
  data,
  control1 = list(trace = 0),
  control2 = list(trace = 0),
  knots.boundary,
  nmix = 1:4,
  df = 1:9,
  fix = TRUE,
  std.err = TRUE,
  nfolds = 5,
  rep = 1,
  messages = 0,
  ...
)
}
\arguments{
\item{model1}{model 1 (exposure measurement error model)}

\item{model2}{model 2}

\item{data}{data.frame}

\item{control1}{optimization parameters for model 1}

\item{control2}{optimization parameters for model 1}

\item{knots.boundary}{boundary points for natural cubic spline basis}

\item{nmix}{number of mixture components}

\item{df}{spline degrees of freedom}

\item{fix}{automatically fix parameters for identification (TRUE)}

\item{std.err}{calculation of standard errors (TRUE)}

\item{nfolds}{Number of folds (cross-validation)}

\item{rep}{Number of repeats of cross-validation}

\item{messages}{print information (>0)}

\item{...}{additional arguments to lower}
}
\description{
Cross-validated two-stage estimator for non-linear SEM
}
\examples{
\donttest{ ## Reduce Ex.Timings##'
m1 <- lvm( x1+x2+x3 ~ u, latent= ~u)
m2 <- lvm( y ~ 1 )
m <- functional(merge(m1,m2), y ~ u, value=function(x) sin(x)+x)
distribution(m, ~u1) <- uniform.lvm(-6,6)
d <- sim(m,n=500,seed=1)
nonlinear(m2) <- y~u1
if (requireNamespace('mets', quietly=TRUE)) {
  set.seed(1)
  val <- twostageCV(m1, m2, data=d, std.err=FALSE, df=2:6, nmix=1:2,
                  nfolds=2)
  val
}
}
}
