% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{zapspace}
\alias{zapspace}
\title{Convert leading or trailing white space and tab characters to nothing.}
\usage{
zapspace(x)
}
\arguments{
\item{x}{A character vector}
}
\value{
If x is a character vector, return is a character vector
    with leading and trailing white space values removed. If x is
    not a character vector, an unaltered x is returned.
}
\description{
This eliminates any characters matched by the regular expression
`\\s` if they appear at the beginning of a string or at its
end. It does not alter spaces in the interior of a string. This
was created when I was not aware of R's \code{trimws} and the purpose
is the same. On our TODO list, we intend to eliminate this function
and replace its use with \code{trimws}
}
\examples{
x <-  c("", " ", "   ", "\t", "\t some", "some\t", " space first")
zapspace(x)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
