% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout.gem}
\alias{layout.gem}
\title{The GEM layout algorithm}
\usage{
layout.gem(
  graph,
  coords = NULL,
  maxiter = 40 * vcount(graph)^2,
  temp.max = max(vcount(graph), 1),
  temp.min = 1/10,
  temp.init = sqrt(max(vcount(graph), 1))
)
}
\arguments{
\item{graph}{The input graph. Edge directions are ignored.}

\item{coords}{If not \code{NULL}, then the starting coordinates should be
given here, in a two or three column matrix, depending on the \code{dim}
argument.}

\item{maxiter}{The maximum number of iterations to perform. Updating a
single vertex counts as an iteration.  A reasonable default is 40 * n * n,
where n is the number of vertices. The original paper suggests 4 * n * n,
but this usually only works if the other parameters are set up carefully.}

\item{temp.max}{The maximum allowed local temperature. A reasonable default
is the number of vertices.}

\item{temp.min}{The global temperature at which the algorithm terminates
(even before reaching \code{maxiter} iterations). A reasonable default is
1/10.}

\item{temp.init}{Initial local temperature of all vertices. A reasonable
default is the square root of the number of vertices.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{layout.gem()} was renamed to \code{layout_with_gem()} to create a more
consistent API.
}
\keyword{internal}
