% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxgrad.R
\name{coxgrad}
\alias{coxgrad}
\title{Compute gradient for Cox model}
\usage{
coxgrad(eta, y, w, std.weights = TRUE, diag.hessian = FALSE)
}
\arguments{
\item{eta}{Fit vector (usually from glmnet at a particular lambda).}

\item{y}{Survival response variable, must be a \code{Surv} or
\code{stratifySurv} object.}

\item{w}{Observation weights (default is all equal to 1).}

\item{std.weights}{If TRUE (default), observation weights are standardized
to sum to 1.}

\item{diag.hessian}{If \code{TRUE}, compute the diagonal of the Hessian
of the log partial likelihood as well. Default is \code{FALSE}.}
}
\value{
A single gradient vector the same length as \code{eta}. If
\code{diag.hessian=TRUE}, the diagonal of the Hessian is
included as an attribute "diag_hessian".
}
\description{
Compute the gradient of the log partial likelihood at a particular fit for Cox
model.
}
\details{
Compute a gradient vector at the fitted vector for the log partial likelihood.
This is like a residual vector, and useful for manual screening of
predictors for \code{glmnet} in applications where \code{p} is very large
(as in GWAS). Uses the Breslow approach to ties.

This function is essentially a wrapper: it checks whether the response
provided is right-censored or (start, stop] survival data, and calls the
appropriate internal routine.
}
\examples{
set.seed(1)
eta <- rnorm(10)
time <- runif(10, min = 1, max = 10)
d <- ifelse(rnorm(10) > 0, 1, 0)
y <- survival::Surv(time, d)
coxgrad(eta, y)

# return diagonal of Hessian as well
coxgrad(eta, y, diag.hessian = TRUE)

# example with (start, stop] data
y2 <- survival::Surv(time, time + runif(10), d)
coxgrad(eta, y2)

# example with strata
y2 <- stratifySurv(y, rep(1:2, length.out = 10))
coxgrad(eta, y2)

}
\seealso{
\code{coxnet.deviance}
}
\keyword{Cox}
\keyword{model}
