% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbivariate.R
\name{ggbivariate}
\alias{ggbivariate}
\title{Display an outcome using several potential explanatory variables}
\usage{
ggbivariate(
  data,
  outcome,
  explanatory = NULL,
  mapping = NULL,
  types = NULL,
  ...,
  rowbar_args = NULL
)
}
\arguments{
\item{data}{dataset to be used, can have both categorical and
numerical variables}

\item{outcome}{name or position of the outcome variable (one variable only)}

\item{explanatory}{names or positions of the explanatory variables (if \code{NULL},
will take all variables other than \code{outcome})}

\item{mapping}{additional aesthetic to be used, for example to indicate
weights (see examples)}

\item{types}{custom types of plots to use, see \code{\link{ggduo}}}

\item{...}{additional arguments passed to \code{\link{ggduo}} (see examples)}

\item{rowbar_args}{additional arguments passed to \code{\link{ggally_rowbar}}
(see examples)}
}
\description{
\code{ggbivariate} is a variant of \code{\link{ggduo}} for plotting
an outcome variable with several potential explanatory variables.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(tips)
p_(ggbivariate(tips, "smoker", c("day", "time", "sex", "tip")))

# Personalize plot title and legend title
p_(ggbivariate(
  tips, "smoker", c("day", "time", "sex", "tip"),
  title = "Custom title"
) +
  labs(fill = "Smoker ?"))

# Customize fill colour scale
p_(ggbivariate(tips, "smoker", c("day", "time", "sex", "tip")) +
  scale_fill_brewer(type = "qual"))

# Customize labels
p_(ggbivariate(
  tips, "smoker", c("day", "time", "sex", "tip"),
  rowbar_args = list(
    colour = "white",
    size = 4,
    fontface = "bold",
    label_format = scales::label_percent(accurary = 1)
  )
))

# Choose the sub-plot from which get legend
p_(ggbivariate(tips, "smoker"))
p_(ggbivariate(tips, "smoker", legend = 3))

# Use mapping to indicate weights
d <- as.data.frame(Titanic)
p_(ggbivariate(d, "Survived", mapping = aes(weight = Freq)))

# outcome can be numerical
p_(ggbivariate(tips, outcome = "tip", title = "tip"))
}
\author{
Joseph Larmarange
}
