\name{distr-package}
\alias{distr-package}
\alias{distr}
\docType{package}
\title{
distr -- Object Oriented Implementation of Distributions
}
\description{
\pkg{distr} provides a conceptual treatment of distributions by means of S4
classes. A mother class \code{Distribution} is introduced with slots for a
parameter and ---most important--- for the four constitutive methods \code{r},
\code{d}, \code{p}, and \code{q} for simulation respectively for evaluation of
density / c.d.f.\ and quantile function of the corresponding distribution.
Most distributions of  package \pkg{stats} (like normal, Poisson, etc.)
are implemented as subclasses of either \code{AbscontDistribution} or
\code{DiscreteDistribution}, which themselves are again subclasses of
\code{Distribution}.
Up to arguments referring to a parameter of the distribution (like
\code{mean} for the normal distribution), these function slots have the
same arguments as those of package \pkg{stats}, i.e.; for a distribution object
\code{X} we may call these functions as
\itemize{
\item \code{r(X)(n)}
\item \code{d(X)(x, log = FALSE)}
\item \code{p(X)(q, lower.tail = TRUE, log.p = FALSE)}
\item \code{q(X)(p, lower.tail = TRUE, log.p = FALSE)}
}
For the arguments of these function slots see e.g. \code{\link{rnorm}}.
Note that, as usual, slots \code{d}, \code{p}, and \code{q} are vectorized
in their first argument, but are not on the subsequent ones.
In the environments of RStudio, see \url{https://posit.co} and
Jupyter IRKernel, see \url{https://github.com/IRkernel/IRkernel},
calls to \code{q} are caught away from standard R evaluation and are treated
in a non-standard way. This non-standard evaluation in particular throws
errors at calls to our accessor methods \code{q} to slot \code{q} of the
respective distribution object. To amend this, we provide function \code{q.l}
as alias to our accessors \code{q}, so that our packages also become available
 in these environments.
Arithmetics and unary mathematical transformations for distributions are
available: For \code{Distribution} objects \code{X} and \code{Y} expressions
like \code{3*X+sin(exp(-Y/4+3))} have their natural interpretation as
corresponding image distributions.
}
\details{
\tabular{ll}{
Package: \tab distr \cr
Version: \tab 2.9.7 \cr
Date: \tab 2025-01-11 \cr
Depends: \tab R(>= 3.4), methods, graphics, startupmsg (>=1.0.0), sfsmisc \cr
Suggests: \tab distrEx, svUnit (>= 0.7-11), knitr, distrMod, ROptEst \cr
Imports: \tab stats, grDevices, utils, MASS \cr
LazyLoad: \tab yes \cr
License: \tab LGPL-3 \cr
URL: \tab https://distr.r-forge.r-project.org/\cr
VCS/SVNRevision: \tab 1482 \cr
}}
\section{Classes}{
Distribution classes have a slot \code{param} the class of which
is is specialized for the particualar distributions. The parameter
classes for the particular distributions have slots with names
according to the corresponding \var{[rdpq]<name>} functions of
package \pkg{base}.
From version 1.9 on, \code{AbscontDistribution} and descendants have
a slot \code{\link{gaps}} for gaps in the support.
\code{DiscreteDistribution} and descendants have
an additional slot \code{\link{support}}, which is again specialized
to be a lattice for class \code{LatticeDistribution}. \cr
For saved objects from earlier versions, we provide the methods
\code{\link{isOldVersion}}, and  \code{\link{conv2NewVersion}}
to check whether the object was generated by an older version of
this package and to convert such an object to the new format,
respectively. This applies to objects of subclasses of
\code{AbscontDistribution} lacking a \code{gap}-slot as well as to
to objects of subclasses of \code{LatticeDistribution} lacking a
\code{lattice}-slot.\cr
To enhance accuracy, from version 1.9 on, we also provide
subclasses \code{AffLinAbscontDistribution}, \code{AffLinDiscreteDistribution},
and \code{AffLinLatticeDistribution}, as well as the class union
\code{AffLinDistribution}, so that in particular functionals like \code{E}
from package \pkg{distrEx} can recur to exact formula more frequently:
These classes have additional slots \code{a}, \code{b}, and \code{X0} to
reflect the fact, that a distribution object of theses classes has the
same distribution as \code{a*X0+b}.\cr
For all particular distributions, as well as for classes
\code{AbscontDistribution}, \code{DiscreteDistribution},
\code{LatticeDistribution}, \code{UnivarDistrList} and \code{DistrList}
generating functions are provided, e.g. \code{X <- Norm(mean = 3, sd = 2)}.
The same goes for the space classes.
All slots should be inspected / modified by means of corresponding
accessor- /replacement functions; e.g. \code{mean(X) <- 3}
Again to enhance accuracy, from version 2.0 on, we also provide
subclasses \code{UnivarMixingDistribution} to support mixing distributions,
\code{UnivarLebDecDistribution}, to support Lebesgue decomposed distributions
(with a discrete and an a.c. part) as well as \code{AffLinUnivarLebDecDistribution},
for corresponding affine linear transformations.
Class \code{UnivarLebDecDistribution} is closed under arithmetical operations
   +  \code{/}, \code{*}, \code{^} for pairs of independent variables
   +  \code{+}, \code{-} for pairs of independent variables
   +  affine linear transformations
   +  truncation, huberization, min/max
which are all now available analytically.\cr
(see Parameter classes).
\preformatted{
[*]: there is a generating function with the same name
##########################
Distribution classes
##########################
slots: [<name>(<class>)]
img(rSpace), param(OptionalParameter),
r(function), d(OptionalFunction), p(OptionalFunction), q(OptionalFunction),
.withSim(logical), .withArith(logical), .logExact(logical), .lowerExact(logical),
Symmetry(DistributionSymmetry)
"Distribution"
|>"UnivariateDistribution"
|>|>"UnivarMixingDistribution"            [*]
|>|>|>"UnivarLebDecDistribution"          [*]
|>|>|>|>"AffLinUnivarLebDecDistribution"
|>|>|>"CompoundDistribution"              [*]
|>|>"AbscontDistribution"                 [*]
|>|>|>"AffLinAbscontDistribution"
|>|>|>"Arcsine"                           [*]
|>|>|>"Beta"                              [*]
|>|>|>"Cauchy"                            [*]
|>|>|>"ExpOrGammaOrChisq" (VIRTUAL)
|>|>|>|>"Exp"                             [*]
|>|>|>|>"Gammad"                          [*]
|>|>|>|>"Chisq"                           [*]
|>|>|>"Fd"                                [*]
|>|>|>"Lnorm"                             [*]
|>|>|>"Logis"                             [*]
|>|>|>"Norm"                              [*]
|>|>|>"Td"                                [*]
|>|>|>"Unif"                              [*]
|>|>|>"Weibull"                           [*]
|>|>|"DiscreteDistribution"               [*]
|>|>|>"AffLinDiscreteDistribution"
|>|>|>"LatticeDistribution"               [*]
|>|>|>|>"AffLinLatticeDistribution"
|>|>|>|>"Binom"                           [*]
|>|>|>|>"Dirac"                           [*]
|>|>|>|>"Hyper"                           [*]
|>|>|>|>"NBinom"                          [*]
|>|>|>|>|>"Geom"                          [*]
|>|>|>|>"Pois"                            [*]
"AffLinDistribution" = union ( "AffLinAbscontDistribution",
                               "AffLinDiscreteDistribution",
                               "AffLinUnivarLebDecDistribution" )
"DistrList"
|>"UnivarDistrList"                       [*]
"AcDcLc" = union ( "AbscontDistribution",
                   "DiscreteDistribution",
                   "UnivarLebDecDistribution" )
##########################
Parameter classes
##########################
"OptionalParameter"
|>"Parameter"
|>|>"BetaParameter"
|>|>"BinomParameter"
|>|>"CauchyParameter"
|>|>"ChisqParameter"
|>|>"DiracParameter"
|>|>"ExpParameter"
|>|>"FParameter"
|>|>"GammaParameter"
|>|>"GeomParameter"
|>|>"HyperParameter"
|>|>"LnormParameter"
|>|>"LogisParameter"
|>|>"NbinomParameter"
|>|>"NormParameter"
|>|>"UniNormParameter"
|>|>|>"PoisParameter"
|>|>"TParameter"
|>|>"UnifParameter"
|>|>"WeibullParameter"
##########################
Space classes
##########################
"rSpace"
|>"EuclideanSpace"
|>|>"Reals"
|>"Lattice"
|>"Naturals"
##########################
Symmetry classes
##########################
slots:
type(character), SymmCenter(ANY)
"Symmetry"
|>"NoSymmetry"          [*]
|>"EllipticalSymmetry"  [*]
|>|>"SphericalSymmetry" [*]
|>"DistributionSymmetry"
|>"FunctionSymmetry"
|>|>"NonSymmetric"      [*]
|>|>"EvenSymmetric"     [*]
|>|>"OddSymmetric"      [*]
list thereof
"DistrSymmList"         [*]
"FunSymmList"           [*]
##########################
Matrix classes
##########################
slots:
none
"PosSemDefSymmMatrix" [*] is subclass of class "matrix" of package "base".
|>"PosDefSymmMatrix"  [*]
##########################
Class unions
##########################
"OptionalNumeric" = union("numeric", "NULL")
"OptionalMatrix" = union("matrix","NULL")
}
}
\section{Methods}{
The group \code{Math} of unary (see \link[methods:S4groupGeneric]{Math}) as well as
convolution are made available for distributions, see \link{operators-methods}
;in particular for convolution powers, we have method \link{convpow}.
Besides, there are \code{plot} and \code{print}-methods for distributions.
For the space classes, we have \code{liesIn}, for the
\code{DicreteDistribution} class, we have \code{liesInSupport}, as well
as a generating function.
The "history" of distributions
obtained by chaining operations may be shortened using \code{simplifyr}.
}
\section{Functions}{
\preformatted{
RtoDPQ                  Default procedure to fill slots d,p,q given r
                        for a.c. distributions
RtoDPQ.d                Default procedure to fill slots d,p,q given r
                        for discrete distributions
RtoDPQ.LC               Default procedure to fill slots d,p,q given r
                        for Lebesgue decomposed distributions
decomposePM             decomposes a distribution into positive and negative
                        part and, if discrete, into part '0'
simplifyD               tries to reduce/simplify mixing distribution using
                        that certain weights are 0
flat.LCD                makes a single UnivarLebDecDistribution out of
                        a list of UnivarLebDecDistribution with corresp. weights
flat.mix                makes a single UnivarLebDecDistribution out of
                        a list of a UnivarMixingDistribution
distroptions            Functions to change the global variables of the
                        package 'distr'
standardMethods         Utility to automatically generate accessor and
                        replacement functions
}}
\note{Arithmetics on distribution objects are understood as operations on
corresponding  (independent) r.v.'s and \strong{not} on distribution functions
or densities.\cr
See also \code{distrARITH()}.\cr
Some functions of package \pkg{stats} have intentionally been masked,
but completely retain their functionality --- see \code{distrMASK()}.\cr
Accuracy of these arithmetics is controlled by global options which may
be inspected / set by \code{distroptions()} and \code{getdistrOption()},
confer \link{distroptions} .
}
\section{Extension Packages in distrXXX family}{
Please note that there are extension packages of this packages
available on CRAN,
\describe{
\item{\pkg{distrDoc}}{a documentation package providing joint documentation
for all packages of the distrXXX family of packages in the form of vignette
'distr'; try \code{require(distrDoc); vignette("distr")}.}
\item{\pkg{distrEx}}{provides functionals (like \code{E}, \code{sd}, \code{mad})
operating on distributions, as well as distances between distributions and basic
support for multivariate and conditional distributions.}
\item{\pkg{distrSim}}{for the standardized treatment of simulations,
also under contaminations.}
\item{\pkg{distrTEst}}{with classes and methods for evaluations of statistical procedures
on simulations generated by \pkg{distrSim}.}
\item{\pkg{distrTeach}}{embodies illustrations for basic stats courses using
our distribution classes.}
\item{\pkg{distrMod}}{provides classes for parametric models and hence covers,
in an object orientated way, estimation in statistical models.}
\item{\pkg{distrEllipse}}{provides classes for elliptically symmetric
distributions.}
}
}
\section{Package versions}{
Note: The first two numbers of package versions do not necessarily reflect
 package-individual development, but rather are chosen for the
 distrXXX family as a whole in order to ease updating "depends"
 information.
}
\section{Acknowledgement}{
We thank Martin Maechler, Josef Leydold, John Chambers,
Duncan Murdoch, Gregory Warnes, Paul Gilbert, Kurt Hornik,
Uwe Ligges, Torsten Hothorn, and Seth Falcon for their help
in preparing this package.}
\author{
Peter Ruckdeschel \email{peter.ruckdeschel@uni-oldenburg.de},\cr
Thomas Stabla \email{statho3@web.de},\cr
Florian Camphausen \email{fcampi@gmx.de},\cr
Matthias Kohl \email{Matthias.Kohl@stamats.de}\cr
\emph{Maintainer:} Peter Ruckdeschel \email{peter.ruckdeschel@uni-oldenburg.de}
}
\references{
P. Ruckdeschel, M. Kohl, T. Stabla, F. Camphausen (2006):
S4 Classes for Distributions, \emph{R News}, \emph{6}(2), 2-6.
\url{https://CRAN.R-project.org/doc/Rnews/Rnews_2006-2.pdf}
P. Ruckdeschel and M. Kohl (2014):
   General purpose convolution algorithm for distributions
  in S4-Classes by means of FFT. \emph{J. Statist. Softw.}
  \bold{59}(4): 1-25.
a vignette for packages \pkg{distr}, \pkg{distrSim}, \pkg{distrTEst}, and
\pkg{distrEx} is included into the mere documentation package \pkg{distrDoc}
and may be called by
\code{require("distrDoc");vignette("distr")}
%a more detailed manual for \pkg{distr}, \pkg{distrSim}, \pkg{distrTEst}, and \pkg{distrEx} may be downloaded from
%\url{http://www.uni-bayreuth.de/departments/math/org/mathe7/DISTR/distr.pdf}
a homepage to this package is available under\cr
\url{https://distr.r-forge.r-project.org/}
}
\section{Start-up-Banner}{
You may suppress the start-up banner/message completely by setting
\code{options("StartupBanner"="off")} somewhere before loading this
package by \code{library} or \code{require} in your R-code / R-session.
If option \code{"StartupBanner"} is not defined (default) or setting
\code{options("StartupBanner"=NULL)} or
\code{options("StartupBanner"="complete")} the complete start-up banner is
displayed.
For any other value of option \code{"StartupBanner"}
(i.e., not in \code{c(NULL,"off","complete")})
only the version information is displayed.
The same can be achieved by wrapping the \code{library} or \code{require}
 call into either \code{suppressStartupMessages()} or
 \code{onlytypeStartupMessages(.,atypes="version")}.
 As for general \code{packageStartupMessage}'s, you may also suppress all
 the start-up banner by wrapping the \code{library} or \code{require}
 call into \code{suppressPackageStartupMessages()} from
 \pkg{startupmsg}-version 0.5 on.
 }
\section{Demos}{
Demos are available --- see \code{demo(package="distr")}}
\keyword{package}
\keyword{distribution}
\concept{absolutely continuous distribution}
\concept{discrete distribution}
\concept{lattice distribution}
\concept{S4 classes}
\concept{arithmetics for distributions}
\concept{S4 parameter class}
\concept{S4 distribution class}
\concept{S4 space class}
\examples{
X <- Unif(2,3)
Y <- Pois(lambda = 3)
Z <- X+Y  # generates Law of corresponding independent variables
p(Z)(0.2)
r(Z)(1000)
plot(Z+sin(Norm()))
}
