% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_trimws}
\alias{ansi_trimws}
\title{Remove leading and/or trailing whitespace from an ANSI string}
\usage{
ansi_trimws(x, which = c("both", "left", "right"))
}
\arguments{
\item{x}{ANSI string vector.}

\item{which}{Whether to remove leading or trailing whitespace or both.}
}
\value{
ANSI string, with the whitespace removed.
}
\description{
This function is similar to \code{\link[base:trimws]{base::trimws()}} but works on ANSI strings,
and keeps color and other styling.
}
\examples{
trimws(paste0("   ", col_red("I am red"), "   "))
ansi_trimws(paste0("   ", col_red("I am red"), "   "))
trimws(col_red("   I am red   "))
ansi_trimws(col_red("   I am red   "))
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_strwrap}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()}
}
\concept{ANSI string operations}
