% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions-VCF.R
\name{breakendRanges}
\alias{breakendRanges}
\alias{breakendRanges,VCF-method}
\title{Extracting unpartnered breakend structural variants as a GRanges}
\usage{
breakendRanges(x, ...)

\S4method{breakendRanges}{VCF}(x, ...)
}
\arguments{
\item{x}{A VCF object.}

\item{...}{Parameters of \code{.breakpointRanges()}. See breakpointRanges for
more details.}
}
\value{
A GRanges object of SVs.
}
\description{
Extracting unpartnered breakend structural variants as a GRanges
}
\details{
The VCF standard supports single breakends where a breakend is not part of a
novel adjacency and lacks a mate. This function supports parsing single
breakends to GRanges, where a dot symbol is used in the ALT field to annotate
the directional information. Single breakends provide insights to situations
when one side of the structural variant is not observed, due to e.g. low
mappability, non-reference contigs, complex multi-break operations, etc.
See Section 5.4.9 of \url{https://samtools.github.io/hts-specs/VCFv4.3.pdf}
for details of single breakends.
}
\section{Methods (by class)}{
\itemize{
\item \code{VCF}: Extracting unpartnered structural variants as 
GRanges.
}}

\examples{
vcf.file <- system.file("extdata", "gridss.vcf",
                         package = "StructuralVariantAnnotation")
vcf <- VariantAnnotation::readVcf(vcf.file, "hg19")
breakendRanges(vcf)
breakendRanges(vcf, nominalPosition=TRUE)
}
