% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\docType{methods}
\name{addCodesetAnnotation,RccSet-method}
\alias{addCodesetAnnotation,RccSet-method}
\alias{addCodesetAnnotation}
\title{Add NanoString codeset annotation to an RccSet}
\usage{
\S4method{addCodesetAnnotation}{RccSet}(rccSet, annot, reorder = TRUE,
  showWarnings = TRUE)
}
\arguments{
\item{rccSet}{An RccSet object.}

\item{annot}{Data frame containing the codeset annotation.}

\item{reorder}{Logical indicating whether the probes should be reordered
according to their barcodes (this can help in identifying
barcode-specific artifacts -- i.e. background noise).}

\item{showWarnings}{Logical indicating whether or not warnings should be shown, if any.}
}
\value{
A copy of the input RccSet where the codeset annotation has been
merged into its fData slot.
}
\description{
Returns a copy of the input RccSet where the codeset annotation
                has been merged into its fData slot. The merge key for each is a string
                formed from the concatenation of their CodeClass, GeneName, and
                Accession columns ("<CodeClass>_<GeneName>_<Accession>"). For creating
                the codeset annotation object, see buildCodesetAnnotation().
}
\examples{
rccDir <- system.file("extdata", "RCC", package="NanoStringQCPro")
rccSet <- newRccSet(rccFiles = dir(rccDir, full.names=TRUE))
rlf <- system.file("extdata", "RLF", "NQCP_example.rlf", package="NanoStringQCPro")
annot <- buildCodesetAnnotation(rlf)
rccSet.annotated <- addCodesetAnnotation(rccSet, annot)

}
\author{
Dorothee Nickles, Robert Ziman
}
