% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumNorm.R
\name{cumNorm}
\alias{cumNorm}
\title{Cumulative sum scaling normalization}
\usage{
cumNorm(obj, p = cumNormStatFast(obj))
}
\arguments{
\item{obj}{An MRexperiment object.}

\item{p}{The pth quantile.}
}
\value{
Object with the normalization factors stored as 
a vector of the sum up to and including a sample's pth quantile.
}
\description{
Calculates each column's quantile and calculates the sum up to and including
that quantile.
}
\examples{

data(mouseData)
mouseData <- cumNorm(mouseData)
head(normFactors(mouseData))

}
\seealso{
\code{\link{fitZig}} \code{\link{cumNormStat}}
}
