% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{computeInfRV}
\alias{computeInfRV}
\title{Compute inferential relative variance (InfRV)}
\usage{
computeInfRV(y, pc = 5, shift = 0.01, meanVariance, useCounts = FALSE)
}
\arguments{
\item{y}{a SummarizedExperiment}

\item{pc}{a pseudocount parameter for the denominator}

\item{shift}{a final shift parameter}

\item{meanVariance}{logical, use pre-computed inferential mean
and variance assays instead of \code{counts} and
computed variance from \code{infReps}. If missing,
will use pre-computed mean and variance when present}

\item{useCounts}{logical, whether to use the MLE
count matrix for the mean instead of mean of inferential replicates.
this argument is for backwards compatability, as previous
versions used counts. Default is FALSE}
}
\value{
a SummarizedExperiment with \code{meanInfRV} in the metadata columns
}
\description{
\code{InfRV} is used the Swish publication for visualization.
This function provides computation of the mean InfRV, a simple
statistic that measures inferential uncertainty.
It also computes and adds the mean and variance of inferential
replicates, which can be useful ahead of \code{\link{plotInfReps}}.
Note that InfRV is not used in the \code{swish}
statistical method at all, it is just for visualization.
See function code for details.
}
