% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eig_decomp.r
\name{eig_decomp}
\alias{eig_decomp}
\title{Fast eigen decomposition using \code{\link[RSpectra]{eigs}}}
\usage{
eig_decomp(M, n_eigs, sym, ..., opts = list())
}
\arguments{
\item{M}{A matrix (e.g. from the Matrix package) or
a function (see \code{\link[RSpectra]{eigs}}).}

\item{n_eigs}{Number of eigenvectors to return.}

\item{sym}{defunct and ignored.}

\item{...}{Passed to \code{\link[RSpectra]{eigs}}.}

\item{opts}{Passed to \code{\link[RSpectra]{eigs}}.}
}
\value{
see \code{\link[RSpectra]{eigs}}.
}
\description{
By default uses a random initialization vector that you can make deterministic using
\code{\link[base]{set.seed}} or override by specifying \code{opts = list(initvec = ...)}.
}
\examples{
eig_decomp(cbind(c(1,0,-1), c(0,1,0), c(-1,0,1)), 2)

}
