# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class RestoreAssistantList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the RestoreAssistantList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantList
        :rtype: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantList
        """
        super(RestoreAssistantList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Assistants/Restore'.format(**self._solution)

    def update(self, assistant):
        """
        Update the RestoreAssistantInstance

        :param unicode assistant: The unique string that identifies the resource

        :returns: The updated RestoreAssistantInstance
        :rtype: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantInstance
        """
        data = values.of({'Assistant': assistant, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return RestoreAssistantInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.RestoreAssistantList>'


class RestoreAssistantPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the RestoreAssistantPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantPage
        :rtype: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantPage
        """
        super(RestoreAssistantPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of RestoreAssistantInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantInstance
        :rtype: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantInstance
        """
        return RestoreAssistantInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.RestoreAssistantPage>'


class RestoreAssistantInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the RestoreAssistantInstance

        :returns: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantInstance
        :rtype: twilio.rest.autopilot.v1.restore_assistant.RestoreAssistantInstance
        """
        super(RestoreAssistantInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'sid': payload.get('sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'unique_name': payload.get('unique_name'),
            'friendly_name': payload.get('friendly_name'),
            'needs_model_build': payload.get('needs_model_build'),
            'latest_model_build_sid': payload.get('latest_model_build_sid'),
            'log_queries': payload.get('log_queries'),
            'development_stage': payload.get('development_stage'),
            'callback_url': payload.get('callback_url'),
            'callback_events': payload.get('callback_events'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def unique_name(self):
        """
        :returns: An application-defined string that uniquely identifies the resource
        :rtype: unicode
        """
        return self._properties['unique_name']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def needs_model_build(self):
        """
        :returns: Whether model needs to be rebuilt
        :rtype: bool
        """
        return self._properties['needs_model_build']

    @property
    def latest_model_build_sid(self):
        """
        :returns: Reserved
        :rtype: unicode
        """
        return self._properties['latest_model_build_sid']

    @property
    def log_queries(self):
        """
        :returns: Whether queries should be logged and kept after training
        :rtype: bool
        """
        return self._properties['log_queries']

    @property
    def development_stage(self):
        """
        :returns: A string describing the state of the assistant.
        :rtype: unicode
        """
        return self._properties['development_stage']

    @property
    def callback_url(self):
        """
        :returns: Reserved
        :rtype: unicode
        """
        return self._properties['callback_url']

    @property
    def callback_events(self):
        """
        :returns: Reserved
        :rtype: unicode
        """
        return self._properties['callback_events']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.RestoreAssistantInstance>'
