# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databoxedge import DataBoxEdgeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxEdgeManagementUsersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxEdgeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_list_by_data_box_edge_device(self, resource_group):
        response = self.client.users.list_by_data_box_edge_device(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_get(self, resource_group):
        response = self.client.users.get(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_begin_create_or_update(self, resource_group):
        response = self.client.users.begin_create_or_update(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            user={
                "encryptedPassword": {"encryptionAlgorithm": "str", "value": "str", "encryptionCertThumbprint": "str"},
                "id": "str",
                "name": "str",
                "shareAccessRights": [{"accessType": "str", "shareId": "str"}],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "userType": "str",
            },
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_users_begin_delete(self, resource_group):
        response = self.client.users.begin_delete(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2021-02-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
