# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementPrivateEndpointConnectionOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_list_by_service(self, resource_group):
        response = self.client.private_endpoint_connection.list_by_service(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_get_by_name(self, resource_group):
        response = self.client.private_endpoint_connection.get_by_name(
            resource_group_name=resource_group.name,
            service_name="str",
            private_endpoint_connection_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_begin_create_or_update(self, resource_group):
        response = self.client.private_endpoint_connection.begin_create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            private_endpoint_connection_name="str",
            private_endpoint_connection_request={
                "id": "str",
                "properties": {
                    "privateLinkServiceConnectionState": {
                        "actionsRequired": "str",
                        "description": "str",
                        "status": "str",
                    }
                },
            },
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_begin_delete(self, resource_group):
        response = self.client.private_endpoint_connection.begin_delete(
            resource_group_name=resource_group.name,
            service_name="str",
            private_endpoint_connection_name="str",
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_list_private_link_resources(self, resource_group):
        response = self.client.private_endpoint_connection.list_private_link_resources(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_get_private_link_resource(self, resource_group):
        response = self.client.private_endpoint_connection.get_private_link_resource(
            resource_group_name=resource_group.name,
            service_name="str",
            private_link_sub_resource_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
