# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import SqlVirtualMachineManagementClientConfiguration
from .operations import AvailabilityGroupListenersOperations
from .operations import Operations
from .operations import SqlVirtualMachineGroupsOperations
from .operations import SqlVirtualMachinesOperations
from . import models


class SqlVirtualMachineManagementClient(SDKClient):
    """The SQL virtual machine management API provides a RESTful set of web APIs that interact with Azure Compute, Network &amp; Storage services to manage your SQL Server virtual machine. The API enables users to create, delete and retrieve a SQL virtual machine, SQL virtual machine group or availability group listener.

    :ivar config: Configuration for client.
    :vartype config: SqlVirtualMachineManagementClientConfiguration

    :ivar availability_group_listeners: AvailabilityGroupListeners operations
    :vartype availability_group_listeners: azure.mgmt.sqlvirtualmachine.operations.AvailabilityGroupListenersOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.sqlvirtualmachine.operations.Operations
    :ivar sql_virtual_machine_groups: SqlVirtualMachineGroups operations
    :vartype sql_virtual_machine_groups: azure.mgmt.sqlvirtualmachine.operations.SqlVirtualMachineGroupsOperations
    :ivar sql_virtual_machines: SqlVirtualMachines operations
    :vartype sql_virtual_machines: azure.mgmt.sqlvirtualmachine.operations.SqlVirtualMachinesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription ID that identifies an Azure
     subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = SqlVirtualMachineManagementClientConfiguration(credentials, subscription_id, base_url)
        super(SqlVirtualMachineManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2017-03-01-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.availability_group_listeners = AvailabilityGroupListenersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.sql_virtual_machine_groups = SqlVirtualMachineGroupsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.sql_virtual_machines = SqlVirtualMachinesOperations(
            self._client, self.config, self._serialize, self._deserialize)
