// Copyright 2020 The Bazel Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v5.28.1
// source: build/bazel/remote/asset/v1/remote_asset.proto

package remoteasset

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Fetch_FetchBlob_FullMethodName      = "/build.bazel.remote.asset.v1.Fetch/FetchBlob"
	Fetch_FetchDirectory_FullMethodName = "/build.bazel.remote.asset.v1.Fetch/FetchDirectory"
)

// FetchClient is the client API for Fetch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FetchClient interface {
	// Resolve or fetch referenced assets, making them available to the caller and
	// other consumers in the [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	//
	// Servers *MAY* fetch content that they do not already have cached, for any
	// URLs they support.
	//
	// Servers *SHOULD* ensure that referenced files are present in the CAS at the
	// time of the response, and (if supported) that they will remain available
	// for a reasonable period of time. The lifetimes of the referenced blobs *SHOULD*
	// be increased if necessary and applicable.
	// In the event that a client receives a reference to content that is no
	// longer present, it *MAY* re-issue the request with
	// `oldest_content_accepted` set to a more recent timestamp than the original
	// attempt, to induce a re-fetch from origin.
	//
	// Servers *MAY* cache fetched content and reuse it for subsequent requests,
	// subject to `oldest_content_accepted`.
	//
	// Servers *MAY* support the complementary [Push][build.bazel.remote.asset.v1.Push]
	// API and allow content to be directly inserted for use in future fetch
	// responses.
	//
	// Servers *MUST* ensure Fetch'd content matches all the specified
	// qualifiers except in the case of previously Push'd resources, for which
	// the server *MAY* trust the pushing client to have set the qualifiers
	// correctly, without validation.
	//
	// Servers not implementing the complementary [Push][build.bazel.remote.asset.v1.Push]
	// API *MUST* reject requests containing qualifiers it does not support.
	//
	// Servers *MAY* transform assets as part of the fetch. For example a
	// tarball fetched by [FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory]
	// might be unpacked, or a Git repository
	// fetched by [FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob]
	// might be passed through `git-archive`.
	//
	// Errors handling the requested assets will be returned as gRPC Status errors
	// here; errors outside the server's control will be returned inline in the
	// `status` field of the response (see comment there for details).
	// The possible RPC errors include:
	//   - `INVALID_ARGUMENT`: One or more arguments were invalid, such as a
	//     qualifier that is not supported by the server.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
	//     perform the requested operation. The client may retry after a delay.
	//   - `UNAVAILABLE`: Due to a transient condition the operation could not be
	//     completed. The client should retry.
	//   - `INTERNAL`: An internal error occurred while performing the operation.
	//     The client should retry.
	//   - `DEADLINE_EXCEEDED`: The fetch could not be completed within the given
	//     RPC deadline. The client should retry for at least as long as the value
	//     provided in `timeout` field of the request.
	//
	// In the case of unsupported qualifiers, the server *SHOULD* additionally
	// send a [BadRequest][google.rpc.BadRequest] error detail where, for each
	// unsupported qualifier, there is a `FieldViolation` with a `field` of
	// `qualifiers.name` and a `description` of `"{qualifier}" not supported`
	// indicating the name of the unsupported qualifier.
	FetchBlob(ctx context.Context, in *FetchBlobRequest, opts ...grpc.CallOption) (*FetchBlobResponse, error)
	FetchDirectory(ctx context.Context, in *FetchDirectoryRequest, opts ...grpc.CallOption) (*FetchDirectoryResponse, error)
}

type fetchClient struct {
	cc grpc.ClientConnInterface
}

func NewFetchClient(cc grpc.ClientConnInterface) FetchClient {
	return &fetchClient{cc}
}

func (c *fetchClient) FetchBlob(ctx context.Context, in *FetchBlobRequest, opts ...grpc.CallOption) (*FetchBlobResponse, error) {
	out := new(FetchBlobResponse)
	err := c.cc.Invoke(ctx, Fetch_FetchBlob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fetchClient) FetchDirectory(ctx context.Context, in *FetchDirectoryRequest, opts ...grpc.CallOption) (*FetchDirectoryResponse, error) {
	out := new(FetchDirectoryResponse)
	err := c.cc.Invoke(ctx, Fetch_FetchDirectory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FetchServer is the server API for Fetch service.
// All implementations should embed UnimplementedFetchServer
// for forward compatibility
type FetchServer interface {
	// Resolve or fetch referenced assets, making them available to the caller and
	// other consumers in the [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
	//
	// Servers *MAY* fetch content that they do not already have cached, for any
	// URLs they support.
	//
	// Servers *SHOULD* ensure that referenced files are present in the CAS at the
	// time of the response, and (if supported) that they will remain available
	// for a reasonable period of time. The lifetimes of the referenced blobs *SHOULD*
	// be increased if necessary and applicable.
	// In the event that a client receives a reference to content that is no
	// longer present, it *MAY* re-issue the request with
	// `oldest_content_accepted` set to a more recent timestamp than the original
	// attempt, to induce a re-fetch from origin.
	//
	// Servers *MAY* cache fetched content and reuse it for subsequent requests,
	// subject to `oldest_content_accepted`.
	//
	// Servers *MAY* support the complementary [Push][build.bazel.remote.asset.v1.Push]
	// API and allow content to be directly inserted for use in future fetch
	// responses.
	//
	// Servers *MUST* ensure Fetch'd content matches all the specified
	// qualifiers except in the case of previously Push'd resources, for which
	// the server *MAY* trust the pushing client to have set the qualifiers
	// correctly, without validation.
	//
	// Servers not implementing the complementary [Push][build.bazel.remote.asset.v1.Push]
	// API *MUST* reject requests containing qualifiers it does not support.
	//
	// Servers *MAY* transform assets as part of the fetch. For example a
	// tarball fetched by [FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory]
	// might be unpacked, or a Git repository
	// fetched by [FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob]
	// might be passed through `git-archive`.
	//
	// Errors handling the requested assets will be returned as gRPC Status errors
	// here; errors outside the server's control will be returned inline in the
	// `status` field of the response (see comment there for details).
	// The possible RPC errors include:
	//   - `INVALID_ARGUMENT`: One or more arguments were invalid, such as a
	//     qualifier that is not supported by the server.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
	//     perform the requested operation. The client may retry after a delay.
	//   - `UNAVAILABLE`: Due to a transient condition the operation could not be
	//     completed. The client should retry.
	//   - `INTERNAL`: An internal error occurred while performing the operation.
	//     The client should retry.
	//   - `DEADLINE_EXCEEDED`: The fetch could not be completed within the given
	//     RPC deadline. The client should retry for at least as long as the value
	//     provided in `timeout` field of the request.
	//
	// In the case of unsupported qualifiers, the server *SHOULD* additionally
	// send a [BadRequest][google.rpc.BadRequest] error detail where, for each
	// unsupported qualifier, there is a `FieldViolation` with a `field` of
	// `qualifiers.name` and a `description` of `"{qualifier}" not supported`
	// indicating the name of the unsupported qualifier.
	FetchBlob(context.Context, *FetchBlobRequest) (*FetchBlobResponse, error)
	FetchDirectory(context.Context, *FetchDirectoryRequest) (*FetchDirectoryResponse, error)
}

// UnimplementedFetchServer should be embedded to have forward compatible implementations.
type UnimplementedFetchServer struct {
}

func (UnimplementedFetchServer) FetchBlob(context.Context, *FetchBlobRequest) (*FetchBlobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchBlob not implemented")
}
func (UnimplementedFetchServer) FetchDirectory(context.Context, *FetchDirectoryRequest) (*FetchDirectoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchDirectory not implemented")
}

// UnsafeFetchServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FetchServer will
// result in compilation errors.
type UnsafeFetchServer interface {
	mustEmbedUnimplementedFetchServer()
}

func RegisterFetchServer(s grpc.ServiceRegistrar, srv FetchServer) {
	s.RegisterService(&Fetch_ServiceDesc, srv)
}

func _Fetch_FetchBlob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchBlobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FetchServer).FetchBlob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Fetch_FetchBlob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FetchServer).FetchBlob(ctx, req.(*FetchBlobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Fetch_FetchDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FetchServer).FetchDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Fetch_FetchDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FetchServer).FetchDirectory(ctx, req.(*FetchDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Fetch_ServiceDesc is the grpc.ServiceDesc for Fetch service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Fetch_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.asset.v1.Fetch",
	HandlerType: (*FetchServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchBlob",
			Handler:    _Fetch_FetchBlob_Handler,
		},
		{
			MethodName: "FetchDirectory",
			Handler:    _Fetch_FetchDirectory_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "build/bazel/remote/asset/v1/remote_asset.proto",
}

const (
	Push_PushBlob_FullMethodName      = "/build.bazel.remote.asset.v1.Push/PushBlob"
	Push_PushDirectory_FullMethodName = "/build.bazel.remote.asset.v1.Push/PushDirectory"
)

// PushClient is the client API for Push service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PushClient interface {
	// These APIs associate the identifying information of a resource, as
	// indicated by URI and optionally Qualifiers, with content available in the
	// CAS. For example, associating a repository url and a commit id with a
	// Directory Digest.
	//
	// Servers *SHOULD* only allow trusted clients to associate content, and *MAY*
	// only allow certain URIs to be pushed.
	//
	// Clients *MUST* ensure associated content is available in CAS prior to
	// pushing.
	//
	// Clients *MUST* ensure the Qualifiers listed correctly match the contents,
	// and Servers *MAY* trust these values without validation.
	// Fetch servers *MAY* require exact match of all qualifiers when returning
	// content previously pushed, or allow fetching content with only a subset of
	// the qualifiers specified on Push.
	//
	// Clients can specify expiration information that the server *SHOULD*
	// respect. Subsequent requests can be used to alter the expiration time.
	//
	// A minimal compliant Fetch implementation may support only Push'd content
	// and return `NOT_FOUND` for any resource that was not pushed first.
	// Alternatively, a compliant implementation may choose to not support Push
	// and only return resources that can be Fetch'd from origin.
	//
	// Errors will be returned as gRPC Status errors.
	// The possible RPC errors include:
	//   - `INVALID_ARGUMENT`: One or more arguments to the RPC were invalid.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
	//     perform the requested operation. The client may retry after a delay.
	//   - `UNAVAILABLE`: Due to a transient condition the operation could not be
	//     completed. The client should retry.
	//   - `INTERNAL`: An internal error occurred while performing the operation.
	//     The client should retry.
	PushBlob(ctx context.Context, in *PushBlobRequest, opts ...grpc.CallOption) (*PushBlobResponse, error)
	PushDirectory(ctx context.Context, in *PushDirectoryRequest, opts ...grpc.CallOption) (*PushDirectoryResponse, error)
}

type pushClient struct {
	cc grpc.ClientConnInterface
}

func NewPushClient(cc grpc.ClientConnInterface) PushClient {
	return &pushClient{cc}
}

func (c *pushClient) PushBlob(ctx context.Context, in *PushBlobRequest, opts ...grpc.CallOption) (*PushBlobResponse, error) {
	out := new(PushBlobResponse)
	err := c.cc.Invoke(ctx, Push_PushBlob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pushClient) PushDirectory(ctx context.Context, in *PushDirectoryRequest, opts ...grpc.CallOption) (*PushDirectoryResponse, error) {
	out := new(PushDirectoryResponse)
	err := c.cc.Invoke(ctx, Push_PushDirectory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PushServer is the server API for Push service.
// All implementations should embed UnimplementedPushServer
// for forward compatibility
type PushServer interface {
	// These APIs associate the identifying information of a resource, as
	// indicated by URI and optionally Qualifiers, with content available in the
	// CAS. For example, associating a repository url and a commit id with a
	// Directory Digest.
	//
	// Servers *SHOULD* only allow trusted clients to associate content, and *MAY*
	// only allow certain URIs to be pushed.
	//
	// Clients *MUST* ensure associated content is available in CAS prior to
	// pushing.
	//
	// Clients *MUST* ensure the Qualifiers listed correctly match the contents,
	// and Servers *MAY* trust these values without validation.
	// Fetch servers *MAY* require exact match of all qualifiers when returning
	// content previously pushed, or allow fetching content with only a subset of
	// the qualifiers specified on Push.
	//
	// Clients can specify expiration information that the server *SHOULD*
	// respect. Subsequent requests can be used to alter the expiration time.
	//
	// A minimal compliant Fetch implementation may support only Push'd content
	// and return `NOT_FOUND` for any resource that was not pushed first.
	// Alternatively, a compliant implementation may choose to not support Push
	// and only return resources that can be Fetch'd from origin.
	//
	// Errors will be returned as gRPC Status errors.
	// The possible RPC errors include:
	//   - `INVALID_ARGUMENT`: One or more arguments to the RPC were invalid.
	//   - `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
	//     perform the requested operation. The client may retry after a delay.
	//   - `UNAVAILABLE`: Due to a transient condition the operation could not be
	//     completed. The client should retry.
	//   - `INTERNAL`: An internal error occurred while performing the operation.
	//     The client should retry.
	PushBlob(context.Context, *PushBlobRequest) (*PushBlobResponse, error)
	PushDirectory(context.Context, *PushDirectoryRequest) (*PushDirectoryResponse, error)
}

// UnimplementedPushServer should be embedded to have forward compatible implementations.
type UnimplementedPushServer struct {
}

func (UnimplementedPushServer) PushBlob(context.Context, *PushBlobRequest) (*PushBlobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushBlob not implemented")
}
func (UnimplementedPushServer) PushDirectory(context.Context, *PushDirectoryRequest) (*PushDirectoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PushDirectory not implemented")
}

// UnsafePushServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PushServer will
// result in compilation errors.
type UnsafePushServer interface {
	mustEmbedUnimplementedPushServer()
}

func RegisterPushServer(s grpc.ServiceRegistrar, srv PushServer) {
	s.RegisterService(&Push_ServiceDesc, srv)
}

func _Push_PushBlob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushBlobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PushServer).PushBlob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Push_PushBlob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PushServer).PushBlob(ctx, req.(*PushBlobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Push_PushDirectory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PushDirectoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PushServer).PushDirectory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Push_PushDirectory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PushServer).PushDirectory(ctx, req.(*PushDirectoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Push_ServiceDesc is the grpc.ServiceDesc for Push service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Push_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "build.bazel.remote.asset.v1.Push",
	HandlerType: (*PushServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PushBlob",
			Handler:    _Push_PushBlob_Handler,
		},
		{
			MethodName: "PushDirectory",
			Handler:    _Push_PushDirectory_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "build/bazel/remote/asset/v1/remote_asset.proto",
}
