-- Can we do operations on f32s, even though these are not natively supported?
-- ==
--
-- input  {
--   [0f32, 0f32, 0f32, 0f32, 0f32]
--   [1, 1, 1, 1, 1]
--   [1f32, 1f32, 1f32, 1f32, 1f32]
-- }
-- output {
--   [0f32, 5f32, 0f32, 0f32, 0f32]
-- }
--
-- input  {
--   [0f32, 0f32, 0f32, 0f32, 0f32]
--   [1, 1, 4, 4, 4]
--   [0.1f32, 0.1f32, 0.4f32, 0.4f32, 0.4f32]
-- }
-- output {
--   [0f32, 0.2f32, 0f32, 0f32, 1.2f32]
-- }
--
-- input  {
--   [1f32, 2f32, 3f32, 4f32, 5f32]
--   [1, 1, 4, 4, 4]
--   [1f32, 1f32, 4f32, 4f32, 4f32]
-- }
-- output {
--   [1f32, 4f32, 3f32, 4f32, 17f32]
-- }
--
-- input  {
--   [1f32, f32.nan, 3f32, 4f32, 5f32]
--   [1, 1, 4, 4, 4]
--   [1f32, 1f32, 4f32, 4f32, 4f32]
-- }
-- output {
--   [1f32, f32.nan, 3f32, 4f32, 17f32]
-- }

def main [m][n] (hist : *[n]f32) (is: [m]i32) (image : [m]f32) : [n]f32 =
  reduce_by_index hist (+) 0f32 (map i64.i32 is) image
