/* PROGRAM:     eggsh
 * FILE:        $Header: /home/egg/src/RCS/genlib.h,v 1.3 1999/02/28 20:05:35 ghn Exp $
 * PURPOSE:     Define general library interface
 * AUTHOR:      Greg Nelson
 * DATE:        98-05-09
 *
 * REVISED:
 * $Log: genlib.h,v $
 * Revision 1.3  1999/02/28 20:05:35  ghn
 * Version 5.1: Changed dquad2sockaddr interface to support ip/mm mask,
 * created hl2dquad to translate host-long to dotted quad, and modified
 * sockaddr2dquad to use this.
 *
 * Revision 1.2  1998/12/31 22:11:05  ghn
 *  Rev 5 code: includes multi-reg support, HTML, etc.
 *
 * Revision 1.1  1998/07/21 11:38:04  ghn
 * Initial revision
 *
 * Copyright 1998 - Greg Nelson
 */

#ifndef _GENLIB_H

#include <unistd.h>
#include <sys/time.h>
#include <netinet/in.h>
#include "global.h"

#define MAX_PARSE	20

#ifdef OBSOLETE
/* This is actually 366 * 24 * 60 * 60, as opposed the actual length
   of the mean solar year which is about 365.2524 days.  */
#define SEC_PER_YEAR    31622400L
#endif

/* Get time in GMT reference frame.  If ztv is NULL, simply returns
   seconds.  Otherwise, returns complete timeval in ztv as well. */
extern int32 getzulutime(struct timeval *ztv);

/* Get difference in msec between two tvs. */
extern int32 deltams(struct timeval *tv1, struct timeval *tv2);

/* Look up an EGG id. */
extern uint16 GetID(void);

/* Create a proper checksummed and packetized byte stream from the raw
   data in memory.  Return result is malloc'ed, so should be freed by
   caller. */
extern char *Packetize(EggCarton *src);

extern int32 Unpacketize(EggCarton *dst, char *src);

/* Compute CRC16 checksum given block and length (from crc16.c) */
extern uint16 BlockCRC16(byte *block, uint32 len);

extern void Parse(char *input, int *argc, char *argv[]);
extern char *mallocpy(char *input);
extern void dquad2sockaddr(struct sockaddr_in *sinp, int16 *mask, char *dquad);
extern char *sockaddr2dquad(struct sockaddr_in *sinp); /* Static buffer! */
extern char *hl2dquad(long addr);	/* Static buffer! */


/* Access to system or emulated usleep(). */

#ifdef USLEEP
extern void sf_usleep(unsigned t);
#define Usleep sf_usleep
#else
#define Usleep usleep
#endif

#define _GENLIB_H
#endif /* _GENLIB_H */
