# ASUS F2A85-M

This page describes how to run coreboot on the [ASUS F2A85-M].

## Variants
- ASUS F2A85-M - Working
- ASUS F2A85-M LE - Working
- ASUS F2A85-M PRO - Working
- ASUS F2A85-M2 - Working
- ASUS F2A85-M/CSM - Unsure if WIP.

## Technology

Both "Trinity" and "Richland" desktop processing units are working,
the CPU architecture in these CPUs/APUs is [Piledriver],
and their GPU is [TeraScale 3] (VLIW4-based).

```{eval-rst}
+------------------+--------------------------------------------------+
| F2A85-M          |                                                  |
+------------------+--------------------------------------------------+
| DDR voltage IC   | Nuvoton NCT3933U (AUX SMBUS 0x15)                |
+------------------+--------------------------------------------------+
| Network          | Realtek RTL8111F                                 |
+------------------+--------------------------------------------------+
| Northbridge      | Integrated into CPU with IMC and GPU (APUs only) |
+------------------+--------------------------------------------------+
| Southbridge      | Hudson-D4                                        |
+------------------+--------------------------------------------------+
| Sound IC         | Realtek ALC887                                   |
+------------------+--------------------------------------------------+
| Super I/O        | ITE 8603E                                        |
+------------------+--------------------------------------------------+
| VRM controller   | DIGI VRM ASP1106 (Rebranded RT8894A - SMBUS 0x20)|
+------------------+--------------------------------------------------+
```

```{eval-rst}
+------------------+--------------------------------------------------+
| F2A85-M LE       |                                                  |
+------------------+--------------------------------------------------+
| DDR voltage IC   | Nuvoton NCT3933U (AUX SMBUS 0x15 - unconfirmed)  |
+------------------+--------------------------------------------------+
| Network          | Realtek RTL8111F                                 |
+------------------+--------------------------------------------------+
| Northbridge      | Integrated into CPU with IMC and GPU(APUs only)  |
+------------------+--------------------------------------------------+
| Southbridge      | Hudson-D4                                        |
+------------------+--------------------------------------------------+
| Sound IC         | Realtek ALC887                                   |
+------------------+--------------------------------------------------+
| Super I/O        | ITE 8623E                                        |
+------------------+--------------------------------------------------+
| VRM controller   | DIGI VRM ASP1106 (Rebranded RT8894A - SMBUS 0x20)|
+------------------+--------------------------------------------------+
```

```{eval-rst}
+------------------+--------------------------------------------------+
| F2A85-M PRO      |                                                  |
+------------------+--------------------------------------------------+
| DDR voltage IC   | Nuvoton NCT3933U (?)                             |
+------------------+--------------------------------------------------+
| Network          | Realtek RTL8111F - Not working                   |
+------------------+--------------------------------------------------+
| Northbridge      | Integrated into CPU with IMC and GPU(APUs only)  |
+------------------+--------------------------------------------------+
| Southbridge      | Hudson-D4                                        |
+------------------+--------------------------------------------------+
| Sound IC         | Realtek ALC887                                   |
+------------------+--------------------------------------------------+
| Super I/O        | Nuvoton NCT6779D                                 |
+------------------+--------------------------------------------------+
| VRM controller   | DIGI VRM ASP1107                                 |
+------------------+--------------------------------------------------+
```

## Flashing coreboot

```{eval-rst}
+---------------------+------------+
| Type                | Value      |
+=====================+============+
| Socketed flash      | yes        |
+---------------------+------------+
| Model               | W25Q64F    |
+---------------------+------------+
| Size                | 8 MiB      |
+---------------------+------------+
| Package             | DIP-8      |
+---------------------+------------+
| Write protection    | no         |
+---------------------+------------+
| Dual BIOS feature   | no         |
+---------------------+------------+
| Internal flashing   | yes        |
+---------------------+------------+
```

### Internal programming

The main SPI flash can be accessed using [flashrom].
UEFI builds that allow flash chip access:
> v5016 is untested, but expected to work as well
> v5018
> v5103
> v5104
> v5107
> v5202
> v6002
> v6004
> v6102
> v6402
> v6404 (requires downgrading to v6402 to flash coreboot)
> v6501 (requires downgrading to v6402 to flash coreboot)
> v6502 (requires downgrading to v6402 to flash coreboot)

Build v6502, v6501 and v6404 do not allow access to the flash chip.
Fortunately it is possible to downgrade build v6502, v6501, v6404 to v6402, with EZFlash.
Downgrading is done by downloading build v6402 from ASUS' F2A85-M download page
and copying it to (the root directory of) a FAT32 formatted USB flash drive.
Enter the EFI setup, switch to advanced mode if necessary,
open the 'Tool' tab and select "ASUS EZ Flash 2 Utility".

## Integrated graphics

### Option 1: Retrieve the VGA optionrom from the vendor EFI binary by running:

    # dd if=/dev/mem of=vgabios.bin bs=1k count=64 skip=768

### Option 2: Extract from the vendor binary

Download the BIOS from the Support section at [ASUS F2A85-M].
Using MMTool Aptio (versions 4.5.0 and 5.0.0):
- Load image, click on 'Extract tab'
- Select the 'export path' and 'link present' options
- Choose option ROM '1002,9900' and click on 'Extract'

This version is usable for all the GPUs.
> 1002,9901 Trinity (Radeon HD 7660D)
> 1002,9904 Trinity (Radeon HD 7560D)
> 1002,990c Richland (Radeon HD 8670D)
> 1002,990e Richland (Radeon HD 8570D)
> 1002,9991 Trinity (Radeon HD 7540D)
> 1002,9993 Trinity (Radeon HD 7480D)
> 1002,9996 Richland (Radeon HD 8470D)
> 1002,9998 Richland (Radeon HD 8370D)
> 1002,999d Richland (Radeon HD 8550D)

## Known issues

- buggy USB 3.0 controller (works fine as 2.0 port)
- reboot, poweroff, S3 suspend/resume (broken since 4.8.1)

## Known issues (untested because of non-working ACPI sleep)

- blink in suspend mode (GP43, program LDN7 F8=23 and blink with F9=2 for 1s blinks)
- fix immediate resume after suspend (perhaps PCIe STS needs to be cleared)
- fix resume with USB3.0 used (perhaps there is a bug in resume.c)

## Untested

- audio over HDMI
- IOMMU
- PS/2 mouse

## TODOs

- manage to use one ATOMBIOS for all the integrated GPUs

## Working

- ACPI
- CPU frequency scaling
- flashrom under coreboot
- Gigabit Ethernet
- Hardware monitor
- Integrated graphics
- KVM
- Onboard audio
- PCIe
- PS/2 keyboard
- SATA
- Serial port
- SuperIO based fan control
- USB (XHCI is buggy)

## Extra resources

- [Board manual]
- Flash chip datasheet [W25Q64FV]

[ASUS F2A85-M]: https://web.archive.org/web/20160320065008/http://www.asus.com/Motherboards/F2A85M/
[Board manual]: https://web.archive.org/web/20211028063105/https://dlcdnets.asus.com/pub/ASUS/mb/SocketFM2/F2A85-M/E8005_F2A85-M.pdf
[flashrom]: https://flashrom.org/
[Piledriver]: https://en.wikipedia.org/wiki/Piledriver_%28microarchitecture%29#APU_lines
[TeraScale 3]: https://en.wikipedia.org/wiki/TeraScale_%28microarchitecture%29#TeraScale_3
[W25Q64FV]: https://web.archive.org/web/20220127184640/https://www.winbond.com/resource-files/w25q64fv%20revs%2007182017.pdf
